seed: 73
cuda: 0 # use_gpu
env:
  env_type: pomdp
  env_name: Pendulum-V-v0

  num_eval_tasks: 20 # num of eval episodes

train:
  # 250*200 = 50k steps
  num_iters: 250 # number meta-training iterates
  num_init_rollouts_pool: 5 # before training
  num_rollouts_per_iter: 1

  num_updates_per_iter: 1.0
  # buffer params
  buffer_size: 1e6
  batch_size: 32 # to tune based on sampled_seq_len
  sampled_seq_len: -1 # -1 is all, or positive integer
  sample_weight_baseline: 0.0

eval:
  eval_stochastic: false # also eval stochastic policy
  log_interval: 5 # num of iters
  save_interval: 100 # -1
  log_tensorboard: true

policy:
  separate: True
  seq_model: ffm # [lstm, gru]
  algo_name: sac # [td3, sac]

  action_embedding_size: 8 # no action input
  observ_embedding_size: 32
  reward_embedding_size: 8
  rnn_hidden_size: 128

  dqn_layers: [128, 128]
  policy_layers: [128, 128]
  lr: 0.0003
  gamma: 0.9
  tau: 0.005

  sac:
    entropy_alpha: 0.2
    automatic_entropy_tuning: true
    alpha_lr: 0.0003

  td3:
    ## since we normalize action space to [-1, 1]
    ## the noise std is absolute value
    exploration_noise: 0.1 
    target_noise: 0.2
    target_noise_clip: 0.5
