import argparse

def args_parser():
    parser = argparse.ArgumentParser()

    # running parameters
    parser.add_argument('--output_dir', type=str, default="./huggingface_cache/", help="output directory")
    parser.add_argument('--seed', type=int, default=16, help="random seed")

    # model
    parser.add_argument('--metric_name', type=str, default="accuracy", help="metric")
    parser.add_argument('--model_checkpoint', type=str, default="gpt2", help="model check point")


    # training
    parser.add_argument('--batch_size', type=int, default=32, help="batch size, a multiple of 8")
    parser.add_argument('--local_lr', type=float, default=9e-4, help="local learning rate")
    parser.add_argument('--glob_lr', type=float, default=2e-3, help="global learning rate")
    parser.add_argument('--lambda', type=float, default=0.05, help="weight decay")
    parser.add_argument('--max_length', type=int, default=256, help="max length of the text sample")

    # fl params
    parser.add_argument('--num_clients', type=int, default=10, help="number of clients")
    parser.add_argument('--num_rounds', type=int, default=10, help="number of fl rounds")
    parser.add_argument('--local_period', type=int, default=32, help="number of fl local period")
    parser.add_argument('--client_range', type=int, default=10, help="clients that are active in training")

    # DDP related
    parser.add_argument("--num_subgroups", type=int, default=1)

    # data files
    parser.add_argument("--training_data", type=str, default="yelp_train.csv")
    parser.add_argument("--test_data", type=str, default="yelp_test.csv")
    parser.add_argument("--partition", type=str, default="yelp_iid_partition.csv")

    # DP related
    parser.add_argument('--epsilon', type=float, default=4, help="targeted privacy budget")
    parser.add_argument('--clipping_constant', type=float, default=1, help="clipping constant for the gradient")
    

    args = parser.parse_args()
    return args