import torch
import copy
import torch.nn as nn
import torch.optim as optim
import numpy as np
from torch.utils.data import DataLoader, Subset
from tqdm import tqdm
import sys
import os
sys.path.append(os.path.abspath('autodl-tmp/Sequential-Unlearnig-main'))
from utils import EarlyStopping, create_pseudo_labels, compute_epoch_grad, compute_grad, compute_epoch_hessian_vector_product, compute_epoch_hessian, evaluate_accuracy, clone_and_freeze_model, load_parameters
from models import CustomModel

def sequential_unlearning(train_dataset, indices, subset_indexs, T, eta, alpha, batch_size, epochs, num_classes, 
                          model_type, resume_model_path, type='real-world', early_stopping=True, ablation='all'):
    device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')
    early_stopping_tag = early_stopping
    
    origin_model = CustomModel(model_name = model_type, num_classes=num_classes, pretrained=False, model_path=resume_model_path).to(device)
    #optimizer = optim.SGD(model.parameters(), lr=0.1, momentum=0.9, weight_decay=5e-4)
    loss_fn = nn.CrossEntropyLoss()

    #theta_0 = [p.clone().detach() for p in origin_model.parameters()]
    prev_theta_star = [p.clone().detach() for p in origin_model.parameters()]
    #indices = np.arange(len(train_dataset))
    indices = indices
    R0_size = len(indices)
    Rt_indices = copy.deepcopy(indices)
    # np.random.shuffle(indices)

    prev_F_t_1_indices = []
    prev_loss = torch.tensor(0.0).to(device)
    total_F_t_size = 0

    for t in range(1, T+1):
        ori_model = copy.deepcopy(origin_model)
        ori_model.train()
        # Ft_indices = indices[(t-1)*1000 : t*1000]
        Ft_indices = subset_indexs[t-1]
        Rt_indices = np.setdiff1d(indices, [*prev_F_t_1_indices, *Ft_indices])
        Ft_loader = DataLoader(Subset(train_dataset, Ft_indices), batch_size=batch_size, shuffle=True)
        pseudo_labels = create_pseudo_labels(num_classes, batch_size).to(device)
        Ft_size = len(Ft_indices)
        total_F_t_size += Ft_size

        sub_model = CustomModel(model_name = model_type, num_classes=num_classes, pretrained=False, model_path=resume_model_path).to(device)
        sub_optimizer = optim.SGD(sub_model.parameters(), lr=eta, momentum=0.9, weight_decay=5e-4)

        if early_stopping_tag:
            early_stopping = EarlyStopping(patience=10, verbose=True, delta=0.01)
        
        # get optimal model theta_t_f
        sub_model.train()
        for epoch in range(epochs):
            total_epoch_loss = torch.tensor(0.0).to(device)
            samples = 0
            for inputs, _ in tqdm(Ft_loader, desc="Sub-model training progress"):
            #for inputs, _ in Ft_loader:
                inputs = inputs.to(device)
                sub_optimizer.zero_grad()
                outputs = sub_model(inputs)
                batch_loss_mean = loss_fn(outputs, pseudo_labels[:outputs.size(0)])
                total_epoch_loss += batch_loss_mean * inputs.size(0)
                samples += inputs.size(0)
                batch_loss_mean.backward()
                sub_optimizer.step()
            mean_epoch_loss = total_epoch_loss / samples
            print(f'Training optimal sub-model F{t}----------epoch: {epoch}---------total epoch loss: {total_epoch_loss}---------mean epoch loss: {mean_epoch_loss}')
            
            if early_stopping_tag:
                # early stop 
                early_stopping(mean_epoch_loss.item())
                if early_stopping.early_stop:
                    print(f'Early stopping at epoch: {epoch}')
                    break
                    
        theta_T_F = [p.clone().detach() for p in sub_model.parameters()]
        print(f'--------------------Finish training {t}-th sub-model !--------------------')

        loss_compute_type = 'sum'
        # compute grad l_t_f
        grad_L_F_t, loss_F_t = compute_epoch_grad(Ft_loader, ori_model, loss_fn, loss_compute_type, pseudo_labels)
        ori_model.zero_grad()
        print(f'--------------------Finish computing grad of LFt !--------------------')
        
        # compute hessian
        total_loader = DataLoader(Subset(train_dataset, indices), batch_size=batch_size, shuffle=False)
        if type == 'dream':
            if t == 1:
                term_1 = [torch.zeros_like(p) for p in ori_model.parameters()]
                hessians = compute_epoch_hessian(ori_model, total_loader, loss_fn, loss_type = loss_compute_type, num_samples=200)
                h0 = [torch.inverse(h) for h in hessians]
            else:
                if loss_compute_type == 'sum':
                    grad_g_t_1_R = compute_grad(prev_loss, list(ori_model.parameters()))
                else:
                    grad_g_t_1_R = compute_grad(prev_loss / t, list(ori_model.parameters()))
                term_1 = [(Ft_size / R0_size) * torch.matmul(h, gtr) for h, gtr in zip(h0, grad_g_t_1_R)]
            ori_model.zero_grad()
            term_2 = [(total_F_t_size / R0_size) * torch.matmul(h, lft) for h, lft in zip(h0, grad_L_F_t)]
            ori_model.zero_grad()
        else:
            if t == 1:
                term_1 = [torch.zeros_like(p) for p in ori_model.parameters()]
            else:
                if loss_compute_type == 'sum':
                    grad_g_t_1_R = compute_grad(prev_loss, list(ori_model.parameters()))
                else:
                    grad_g_t_1_R = compute_grad(prev_loss / t, list(ori_model.parameters()))
                ori_model.zero_grad()
                hvp_1 = compute_epoch_hessian_vector_product(ori_model, total_loader, loss_fn, grad_g_t_1_R, loss_type = loss_compute_type,num_samples=200)
                term_1 = [(Ft_size / R0_size) * grad for grad in hvp_1]
                ori_model.zero_grad()
            hvp_2 = compute_epoch_hessian_vector_product(ori_model, total_loader, loss_fn, grad_L_F_t, loss_type = loss_compute_type,num_samples=200)
            term_2 = [(total_F_t_size / R0_size) * grad for grad in hvp_2]
            ori_model.zero_grad()
        print(f'--------------------Finish computing grad of tem1 and term2 !--------------------')

        # aggregation the optimal model
        opt_param = [torch.zeros_like(p) for p in ori_model.parameters()]
        with torch.no_grad():  # 更新参数时不需要计算梯度
            for idx, _ in enumerate(opt_param):
                opt_param[idx] = (1 / (t+1)) * theta_T_F[idx] + (t / (t+1)) * prev_theta_star[idx] + (alpha / (1 + t)) * term_1[idx] + (alpha / (1 + t)) * term_2[idx]
        print(f'--------------------Finish aggregating parameters !--------------------')
        
        # update previous time param
        prev_loss += loss_F_t
        prev_theta_star = copy.deepcopy(opt_param)
        
        # update current optimal model
        load_parameters(ori_model, opt_param)

        # evaluate
        print(f'indices length: {len(indices)}, Ft_indices length:{len(Ft_indices)},  Rt_indices length: {len( Rt_indices)}, prev_F_t_1_indices length: {len(prev_F_t_1_indices)}')
        if len(Rt_indices) == 0:
            Acc_Rt = 0
        else:
            Rt_loader = DataLoader(Subset(train_dataset, Rt_indices), batch_size=batch_size)
            Acc_Rt = evaluate_accuracy(ori_model, Rt_loader)
        Acc_Ft = evaluate_accuracy(ori_model, Ft_loader)

        if t == 1:
            Acc_F_t_1 = 0.0
            #Acc_R_t_1 = evaluate_accuracy(model, DataLoader(Subset(train_dataset, indices), batch_size=128, shuffle=False))
        else:
            F_t_1_indices = prev_F_t_1_indices
            Acc_F_t_1 = evaluate_accuracy(ori_model, DataLoader(Subset(train_dataset, F_t_1_indices), batch_size=batch_size, shuffle=False))
            #R_t_1_indices = [*Rt_indices, *Ft_indices]
            #Acc_R_t_1 = evaluate_accuracy(model, DataLoader(Subset(train_dataset, R_t_1_indices), batch_size=128, shuffle=False))
        
        prev_F_t_1_indices.extend(Ft_indices)

        #print(f"Time {t}: Acc_Ft: {Acc_Ft:.4f}, Acc_Rt: {Acc_Rt:.4f}, Acc_F_t-1: {Acc_F_t_1:.4f}, Acc_R_t-1: {Acc_R_t_1:.4f}")
        print(f"Time {t}: Acc_Ft: {Acc_Ft:.4f}, Acc_Rt: {Acc_Rt:.4f}, Acc_F_t-1: {Acc_F_t_1:.4f}")

    return 0