import torch
import copy
import numpy as np
import torch.nn as nn
import torch.optim as optim
from torch.utils.data import DataLoader, Subset
from tqdm import tqdm
import sys
import os
sys.path.append(os.path.abspath('autodl-tmp/Sequential-Unlearnig-main'))
from utils import compute_grad, compute_epoch_hessian_vector_product, compute_epoch_hessian, compute_hessian, evaluate_accuracy
from models import CustomModel


def update_model_parameters(model, param_updates, hyper_param=1.0):
    # 使用与模型参数相同的设备来处理更新（例如CPU或GPU）
    device = next(model.parameters()).device

    # 遍历现有模型参数及其对应的更新
    with torch.no_grad():  # 更新参数时不需要计算梯度
        for param, update in zip(model.parameters(), param_updates):
            param.add_(hyper_param * update.to(device))  # 将更新添加到原参数，确保更新在正确的设备上
            

def influence_baseline(train_dataset, indices, subset_indexs, T, eta, batch_size, epochs, num_classes, model_type, resume_model_path):
    device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')

    baseline_model = CustomModel(model_name = model_type, num_classes=num_classes, pretrained=False, model_path=resume_model_path).to(device)
    loss_fn = nn.CrossEntropyLoss()
    baseline_optimizer = optim.SGD(baseline_model.parameters(), lr=eta, momentum=0.9, weight_decay=5e-4)

    prev_theta_star = [p.clone().detach() for p in baseline_model.parameters()]

    indices = indices
    Rt_indices = copy.deepcopy(indices)
    prev_F_t_1_indices = []

    n = len(indices)
    lambda_val = 0.1
    
    going_type = 'real-world'
    if going_type == 'dream':
        # 设置假定的参数
        epsilon = 0.01
        delta = 0.1
        M = 1
        L = 1
        m = 128
        
        # 计算 γ 和 σ
        gamma = (2 * M * m**2 * L**2) / (lambda_val**3 * n**2)
        sigma = (gamma / epsilon) * torch.sqrt(2 * torch.log(torch.tensor(1.25 / delta)))
        
    baseline_model.train()
    for t in range(1, T+1):
        # Ft_indices = indices[(t-1)*1000 : t*1000]
        Ft_indices = subset_indexs[t-1]
        Rt_indices = np.setdiff1d(indices, [*prev_F_t_1_indices, *Ft_indices])
        m = len(Ft_indices)

        Ft_loader = DataLoader(Subset(train_dataset, Ft_indices), batch_size=batch_size, shuffle=True)
        total_loader = DataLoader(Subset(train_dataset, indices), batch_size=batch_size, shuffle=True)
        
        # incluence-train, do not need epochs
        base_loss = torch.tensor(0.0).to(device)
        total_samples = 0
        for inputs, targets in tqdm(Ft_loader, desc="Training progress"):
            inputs, targets = inputs.to(device), targets.to(device)
            outputs = baseline_model(inputs)
            base_loss += loss_fn(outputs, targets) * inputs.size(0)
            total_samples += inputs.size(0)
        l2_norm_loss = sum(p.pow(2.0).sum() for p in baseline_model.parameters())
        loss_total = base_loss + 0.5 * lambda_val * l2_norm_loss
        loss_mean = loss_total / total_samples
        #total_loss.backward()
        print(f'Influence baseline model R{t}----------time: {t}---------base loss: {base_loss}---------l2 loss: {l2_norm_loss}---------total epoch loss: {loss_total}')
        
        loss_compute_type = 'sum'
        if going_type == 'dream':
            F_grad_grad = compute_epoch_hessian(total_loader, baseline_model, loss_fn, loss_type = loss_compute_type, num_samples=200)
            baseline_model.zero_grad()
            if loss_compute_type == 'sum':
                f_grad = compute_grad(base_loss_total, list(baseline_model.parameters()))
                baseline_model.zero_grad()
                f_grad_grad = compute_hessian(base_loss_total, list(baseline_model.parameters()))
                baseline_model.zero_grad()
            else:
                f_grad = compute_grad(base_loss_mean, list(baseline_model.parameters()))
                baseline_model.zero_grad()
                f_grad_grad = compute_hessian(base_loss_mean, list(baseline_model.parameters()))
                baseline_model.zero_grad()
            inverse_H_hat = [(1 / (n - m)) * torch.inverse(F_gg - f_gg) for F_gg, f_gg in zip(F_grad_grad, f_grad_grad)]
            param_update = [(1 / (n - m)) * torch.matmul(ihh - fg) for ihh, fg in zip(inverse_H_hat, f_grad)]
        else:
            if loss_compute_type == 'sum':
                f_grad = compute_grad(loss_total, list(baseline_model.parameters()))
            else:
                f_grad = compute_grad(loss_mean, list(baseline_model.parameters()))
            baseline_model.zero_grad()
            hvp = compute_epoch_hessian_vector_product(baseline_model, total_loader, loss_fn, f_grad, loss_type = loss_compute_type, num_samples=200)
            param_update = [(1 / (n - m)) * grad for grad in hvp]

        # 更新模型参数
        update_model_parameters(baseline_model, param_update)

        # 将更新后的模型参数保存在 prev_theta_star 中
        # prev_theta_star = [param.clone().detach() for param in model.parameters()]

        # 采样高斯噪声
        # noise = torch.normal(0, sigma, size=(d,))

        # evaluate
        print(f'indices length: {len(indices)}, Ft_indices length:{len(Ft_indices)},  Rt_indices length: {len( Rt_indices)}, prev_F_t_1_indices length: {len(prev_F_t_1_indices)}')
        if len(Rt_indices) == 0:
            Acc_Rt = 0
        else:
            Rt_loader = DataLoader(Subset(train_dataset, Rt_indices), batch_size=batch_size)
            Acc_Rt = evaluate_accuracy(baseline_model, Rt_loader)
        Acc_Ft = evaluate_accuracy(baseline_model, Ft_loader)

        if t == 1:
            Acc_F_t_1 = 0.0
        else:
            Acc_F_t_1 = evaluate_accuracy(baseline_model, DataLoader(Subset(train_dataset, prev_F_t_1_indices), batch_size=128, shuffle=False))
        
        prev_F_t_1_indices.extend(Ft_indices)

        print(f"Time {t}: Acc_Ft: {Acc_Ft:.4f}, Acc_Rt: {Acc_Rt:.4f}, Acc_F_t-1: {Acc_F_t_1:.4f}")
    
    return 0