from __future__ import annotations

from typing import Any, Protocol
from rules.lens import Putter, Scratch, State, Value


Bool = Any
Data = Any
Label = Any
Logit = Any
Noise = Any



class Discriminator(Protocol):
    def __call__(self, data: Data) -> Logit: ...

    def predict(self, data: Data) -> Bool: ...


class Generator(Protocol):
    def __call__(self, noise: Noise) -> Data: ...


def real(discriminator: Discriminator,
         data: Data,
         label: Label) -> tuple[Logit, Label]:
    prediction = discriminator(data)
    target = label

    return prediction, target


def fake(generator: Generator,
         discriminator: Discriminator,
         noise: Noise,
         label: Label) -> tuple[Logit, Label]:
    data = generator(noise)
    prediction = discriminator(data)
    target = label

    return prediction, target


def fool(generator: Generator,
         discriminator: Discriminator,
         noise: Noise,
         label: Label) -> tuple[Logit, Label]:
    data = generator(noise)
    prediction = discriminator(data)
    target = label

    return prediction, target


def fake_putter(putter: Putter,
                discriminator: Discriminator,
                state: State,
                value: Value,
                scratch: Scratch,
                label: Label) -> tuple[Logit, Label]:
    data = putter.put(state, value, scratch)
    prediction = discriminator(data)
    target = label

    return prediction, target


def fool_putter(putter: Putter,
                discriminator: Discriminator,
                state: State,
                value: Value,
                scratch: Scratch,
                label: Label) -> tuple[Logit, Label]:
    data = putter.put(state, value, scratch)
    prediction = discriminator(data)
    target = label

    return prediction, target
