from __future__ import annotations

from typing import Any, Optional, Protocol


Prediction = Any
State = Any
Value = Any
Scratch = Any


class Getter(Protocol):
    def __call__(self, state: State) -> Prediction: ...

    def get(self, state: State) -> Value: ...


class Putter(Protocol):
    def __call__(self, state: State, value: Value, scratch: Optional[Scratch]) -> Prediction: ...

    def put(self, state: State, value: Value, scratch: Optional[Scratch]) -> State: ...


def classify(getter: Getter,
             state: State,
             value: Value) -> tuple[Value, Value]:
    prediction = getter(state)
    target = value

    return prediction, target


def get_put(getter: Getter,
            putter: Putter,
            state: State,
            scratch: Scratch) -> tuple[State, State]:
    prediction = putter(state, getter.get(state), scratch)
    target = state

    return prediction, target


def put(putter: Putter,
        state: State,
        value: Value,
        scratch: Scratch) -> tuple[State, State]:
    prediction = putter(state, value, scratch)
    target = state

    return prediction, target


def put_get(putter: Putter,
            getter: Getter,
            state: State,
            value: Value,
            scratch: Scratch) -> tuple[Value, Value]:
    prediction = getter(putter.put(state, value, scratch))
    target = value

    return prediction, target


def put_put(putter: Putter,
            state: State,
            value1: Value,
            scratch1: Scratch,
            value2: Value,
            scratch2: Scratch) -> tuple[State, State]:
    prediction = putter(putter.put(state, value1, scratch1), value2, scratch2)
    target = putter(state, value2, scratch2)

    return prediction, target


def undo(putter: Putter,
         getter: Getter,
         state: State,
         value: Value,
         scratch1: Scratch,
         scratch2: Scratch) -> tuple[State, State]:
    prediction = putter(putter.put(state, value, scratch1), getter.get(state), scratch2)
    target = state

    return prediction, target


def put_get_fake(putter: Putter,
                 getter: Getter,
                 state: State,
                 value: Value,
                 scratch: Scratch) -> tuple[Value, Value]:
    prediction = getter(putter.put(state, value, scratch))
    target = getter.get(state)

    return prediction, target


def put_identity(putter: Putter,
                 state: State,
                 value: Value,
                 scratch: Scratch) -> tuple[State, State]:
    prediction = putter.put(state, value, scratch)
    target = state

    return prediction, target
