from __future__ import annotations

from typing import Any, Protocol


Prediction = Any
State = Any
Value = Any


class Getter(Protocol):
    def __call__(self, state: State) -> Prediction: ...

    def get(self, state: State) -> Value: ...


class Putter(Protocol):
    def __call__(self, state: State, value: Value) -> Prediction: ...

    def put(self, state: State, value: Value) -> State: ...


def masked_classify(getter: Getter,
             putter: Putter,
             state: State,
             true_value: Value,
             random_value: Value) -> tuple[Value, Value]:
    
    
    prediction = getter(putter.put(state, random_value))
    target = true_value

    return prediction, target



