from __future__ import annotations

from typing import Any, Protocol


Data = Any


class AutoEncoder(Protocol):
    def __call__(self, data: Data) -> Data: ...


def autoencode(autoencoder: AutoEncoder,
               data: Data) -> Data:
    reconstruction = autoencoder(data)

    return reconstruction, data
