from __future__ import annotations

from typing import Any, Protocol


State = Any
Value = Any


class Getter(Protocol):
    def __call__(self, state: State) -> Value: ...

    def get(self, state: State) -> Value: ...


class Putter(Protocol):
    def __call__(self, value: Value, state: State) -> State: ...


def classify(getter: Getter,
             state: State,
             value: Value) -> tuple[Value, Value]:
    prediction = getter(state)
    target = value

    return prediction, target


def get_put(getter: Getter,
            putter: Putter,
            state: State) -> tuple[State, State]:
    prediction, _ = putter(getter(state), state)
    target = state

    return prediction, target


def get_put_teacher_forced(putter: Putter,
                           state: State,
                           value: Value) -> tuple[State, State]:
    prediction, _ = putter(value, state)
    target = state

    return prediction, target


def put_get(putter: Putter,
            getter: Getter,
            state: State,
            value: Value) -> tuple[Value, Value]:
    put_output, _ = putter(value, state)
    prediction = getter(put_output)
    target = value

    return prediction, target


def put_put(putter: Putter,
            state: State,
            value1: Value,
            value2: Value) -> tuple[State, State]:
    put_output, complement = putter(value1, state)
    prediction, _ = putter(value2, put_output, complement)
    target, _ = putter(value2, state)

    return prediction, target


def undo_teacher_forced(putter: Putter,
                        state: State,
                        value: Value,
                        random_value: Value) -> tuple[State, State]:
    put_output, complement = putter(random_value, state)
    prediction, _ = putter(value, put_output, complement)
    target = state

    return prediction, target
