# Diffusion-RainbowPA: Improvements Combined Preference Alignment for Diffusion-based Text-to-Image Generation

## :wrench: Generation
Here, we take the generation of the Diffusion-RainbowPA model under the DPG-Bench dataset as an example.
```bash
cd ./evaluating/image_generation/DPG-Bench

python generation_RainbowPA.py
```
In the folder "./evaluating/image_generation/", we provide generation code for all datasets. When utilizing them for generation, please ensure you set the model paths correctly.

## :wrench: Evaluation
Here, we provide the evaluation code for all four datasets with the VQAScore, CLIPScore, HPS-V2, and ImageReward. Here, we take the DPG-Bench as an example.
```bash
cd ./evaluating/DPG-Bench/Testing

python VQAScore_count.py

python Clip_count.py

python HPS-V2_count.py

python ImageReward_count.py
```
Furthermore, you can test the winning rate of the Diffusion-RainbowPA compared to other methods with model feedback. Our code provides an example based on the CLIPScore; further, you can refer to the codes in folder "./Testing" and adapt them to evaluate the VQAScore, HPS-V2, and ImageReward. Here is the example with the CLIPScore on the DPG-Bench.

```bash
cd ./evaluating/DPG-Bench/Winning-Rate-with-CLIPScore

python Diffusion-RainbowPA-vs-SD1-5.py

python Diffusion-RainbowPA-vs-Diffusion-DPO.py

python Diffusion-RainbowPA-vs-SPO.py

python Diffusion-RainbowPA-vs-SPO_LoRA.py

python Diffusion-RainbowPA-vs-SPIN-Diffusion.py

python Diffusion-RainbowPA-vs-SePPO.py
```
