# Diffusion-RainbowPA: Improvements Combined Preference Alignment for Diffusion-based Text-to-Image Generation

## Acknowledgements
This implementation is based on the codebase provided by [SPO](https://github.com/RockeyCoss/SPO), [D3PO](https://github.com/yk7333/d3po), [Diffusion-DPO](https://github.com/SalesforceAIResearch/DiffusionDPO), [Diffusers](https://github.com/huggingface/diffusers) and [PickScore](https://github.com/yuvalkirstain/PickScore). The public availability of them significantly facilitated our research, and we gratefully acknowledge their authors' contribution.

## :wrench: Training
Please refer to the README.md in the folder "./training"

## :wrench: Evaluating
Please refer to the README.md in the folder "./evaluating"

## :wrench: Example: have a try
Before running the example file, please ensure that you have completed the environment configuration in "./training/environment.yaml".

Due to the size limitations for supplementary materials, we only attach the Lora weights of model training here for your reference, which is available at "./lora_weights.safetensors". 

You can have a try using the following command line:

```bash
python example.py --device "cuda:0" --lora_path "./lora_weights.safetensors" --prompt "A cute duck wearing a chef uniform covered in cookie batter, unreal engine render 8k" 
```
