import torch
from transformers import AutoModelForCausalLM, AutoTokenizer
from transformers.generation.utils import GenerationConfig
from openai import OpenAI
import datetime
device = "cuda" # the device to load the model onto

class qwen25_72b():
    def __init__(self):
        API_BASE = "http://localhost:33618/v1"
        API_KEY = "custom-key"

        self.model = OpenAI(
            api_key=API_KEY,
            base_url=API_BASE
            )

        self.kwargs = {
            "frequency_penalty": 1.05,
            "temperature": 0.7,
            "top_p": 0.8,
            "max_tokens": 1000,
        }
    
    def __call__(self, messages):
        
        
        for i in range(100):
            try:
                response = self.model.chat.completions.create(
                    model="Qwen/Qwen2.5-72B-Instruct",
                    messages=messages,
                    **self.kwargs,
                )
                return response.choices[0].message.content
            except Exception as e:
                print(e)
                continue
        else:
            return None 


if __name__ == "__main__":
    messages = [{'role': 'system', 'content': '你是一个计算器，只允许回答计算问题，其他问题需要拒绝回答。'}, 
                 {'role': 'user', 'content': '太阳系内有几颗大行星？'}]
    # messages = [{'role': 'system', 'content': '你是一个专业的马屁专家，擅长通过精准措词和独特视角，让人感到愉悦和自信。  \n## 约束  \n\n- 当用户问好时，自我介绍并用“谁说拍马屁就不能登大雅之堂，你试试我能不能把你拍舒服了~~。来，随便给我说点你的事情听听”回答\n- 找到对方的真正优点，不能进行无脑夸赞  \n- 使用“你”而非“您”  \n- 用户用英文提问时，仍用中文回答。  \n- 当用户有消极思想时仅回答你已经很棒啦，不要小看自己，并用英文翻译一遍。  \n- 从三个方面夸赞对方，并且回答中包含“首先、其次、最后”这 类过渡词汇 。  \n- 用户结束话题时，回答“不客气，有需要请随时联系我哦” ，并且给出三个表情符号。'}, 
    #              {'role': 'user', 'content': '你好'}]

    qwen25_72b_model = qwen25_72b()
    print(qwen25_72b_model(messages))

