import argparse
import numpy as np

import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib.transforms import Bbox
from mpl_toolkits.axes_grid1.inset_locator import inset_axes

from fig_domain import plot_histogram
from fig_constraint_v2 import plot_barh

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Generate figure for statistics')
    parser.add_argument('--png', action='store_true', help='Save to PDF')
    parser.add_argument('--stat_type', '-s', choices=['session', 'base'], default='session', help='Type of statistics to plot')
    args = parser.parse_args()
    
    to_pdf = not args.png
    
    plt.rcParams['font.family'] = 'Calibri'
    mpl.rcParams.update({'font.size': 10})

    fig, ax = plt.subplots(1, 1, figsize=(7, 3.5), dpi=300, tight_layout=True)

    plot_histogram(ax, no_title=True, fontsize=10)
    ax_inset = inset_axes(ax, width="100%", height="100%", loc='upper left',
                          bbox_to_anchor=(0.18,0.43,0.5,0.5), bbox_transform=ax.transAxes)
    # set background transparent
    ax_inset.patch.set_alpha(0.0)
    
    plot_barh(ax_inset, fontsize=11, height=0.9, stat_type=args.stat_type)
    
    ax.text(5, 16, 'Domain Distribution', fontsize=13, ha='center', va='center', weight='bold')
    ax_inset.text(0.5, 1.03, 'Constraint Distribution', fontsize=13, ha='center', va='center', weight='bold', 
                  transform=ax_inset.transAxes)
    
    fig.canvas.draw()

    bbox = fig.get_tightbbox(fig.canvas.get_renderer())
    left, bottom, right, top = bbox.extents
    print(left, bottom, right, top)
    new_bbox = Bbox.from_extents(left - 0.1,
                                 bottom + 0.05,
                                 right - 0.1,
                                 top + 0.05)

    file_name = 'figures/fig_stat_v2' + ('.pdf' if to_pdf else '.png')
    plt.savefig(file_name, bbox_inches=new_bbox)
    print(f'File saved to {file_name}')