#python3 -m stats.tstat_results_analysis +exp=tstat_results ++exp.tstat_results_path=/storage/czw/seeg_decoding/outputs/tstat_results

import hydra
import logging
from omegaconf import DictConfig, OmegaConf
import os 
import json

log = logging.getLogger(__name__)


@hydra.main(config_path="../conf")
def main(cfg: DictConfig) -> None:
    log.info(f"run tstat results analysis")
    log.info(OmegaConf.to_yaml(cfg, resolve=True))
    out_dir = cfg.exp.get("out_dir", None)
    if not out_dir:
        out_dir = os.getcwd()
    else:
        Path(out_dir).mkdir(exist_ok=True, parents=True)
    log.info(f'Working directory {out_dir}')
    results_path = os.path.join(cfg.exp.tstat_results_path, 'all_results.json')
    with open(results_path, "r") as f:
        results = json.load(f)

    alpha = 0.001
    elec_sigs = []
    import pdb; pdb.set_trace()
    for elec in results:
        elec_results = results[elec]
        feature_sigs = []
        for features in elec_results:
            features_pvals = elec_results[features]["pvals"]
            feature_sig = all([p<alpha for p in features_pvals])

            feature_sigs.append(feature_sig)

        elec_sig = all(feature_sigs)
        if elec_sig:
            elec_sigs.append(elec)
    import pdb; pdb.set_trace()

if __name__ == "__main__":
    main()
