
# Pre-training also Transfers Non-Robustness
This repository is the official implementation of Pre-training also Transfers Non-Robustness.

## Requirements
To install requirements:
```
pip install -r requirements.txt
```
or make sure the following libraries are in your environment:

- numpy
- torch(GPU)
- torchvision
- pillow
- pyyaml
- foolbox

## Datasets that we use
- flowers [(Download)](https://robustnessws4285631339.blob.core.windows.net/public-datasets/flowers.tar?sv=2019-10-10&ss=b&srt=sco&sp=rlx&se=2021-10-05T15:06:23Z&st=2020-06-10T07:06:23Z&spr=https&sig=Rwwsg9yfcSrbNLvxse%2F32XOy7ERWSLXMz9Ebka4pS20%3D)
- pets [(Download)](https://robustnessws4285631339.blob.core.windows.net/public-datasets/pets.tar?sv=2019-10-10&ss=b&srt=sco&sp=rlx&se=2021-10-05T15:06:23Z&st=2020-06-10T07:06:23Z&spr=https&sig=Rwwsg9yfcSrbNLvxse%2F32XOy7ERWSLXMz9Ebka4pS20%3D)
- food [(Download)](https://robustnessws4285631339.blob.core.windows.net/public-datasets/food.tar?sv=2019-10-10&ss=b&srt=sco&sp=rlx&se=2021-10-05T15:06:23Z&st=2020-06-10T07:06:23Z&spr=https&sig=Rwwsg9yfcSrbNLvxse%2F32XOy7ERWSLXMz9Ebka4pS20%3D)
- cifar10 (Automatically download by torchvision)
- cars [(Download)](https://robustnessws4285631339.blob.core.windows.net/public-datasets/stanford_cars.tar?sv=2019-10-10&ss=b&srt=sco&sp=rlx&se=2021-10-05T15:06:23Z&st=2020-06-10T07:06:23Z&spr=https&sig=Rwwsg9yfcSrbNLvxse%2F32XOy7ERWSLXMz9Ebka4pS20%3D)
- alphabet [(Download)](https://zenodo.org/record/4781907/files/alphabet.zip?download=1)
- NICO [(Download)](https://zenodo.org/record/4807599/files/NICO.zip?download=1)

To use any datasets with our code, you need make directory as follow:
```
datasets
    └─<dataset>
        ├─train
        │  ├─class_1
        │  └─class_2
        └─test
            ├─class_1
            └─class_2

# e.g.
datasets
    └─pets
        ├─train
        │  ├─cat
        │  └─dog
        └─test
            ├─cat
            └─dog
```
Then, add the dataset and root path as arguments, e.g.
```
python train.py ... --dataset pets --root ./datasets 
```

## Training
To train the model in the paper, run this command:
```
#!./script/train_finetune.sh

python train.py --backbone resnet18 --train finetune --device 0 \
                --root datasets/ --dataset cifar10 --data_conf conf_finetune.yaml  \
                --save checkpoint/resnet18/resnet18_cifar10_finetune.pth
```

## Evaluation
To evaluate the model, run this command:
```
#!./script/eval_accuracy.sh

python eval.py --backbone resnet18 --adv pgd --eps 0.5 --device 0 \
               --root datasets/ --dataset cifar10 --data_conf conf_finetune.yaml  \
               --load checkpoint/resnet18/resnet18_cifar10_finetune.pth
```
Also, we provide the models for our Robust Pre-training solution. You can download from zenodo, [here](https://zenodo.org/record/4836393).

## Results
Check out our paper for more details.