#!/bin/bash

datasets=("pets" "nico" "alphabet" "cars" "cifar10" "flowers" "food")
backbone="resnet18"
# shellcheck disable=SC2068
for dataset in ${datasets[@]}
do
  python svcca.py --device 2 --root /data/jiaming/datasets --dataset $dataset \
    --standard "checkpoints/${backbone}/${backbone}_${dataset}_standard.pth" \
    --finetune "checkpoints/${backbone}/${backbone}_${dataset}_finetune.pth" \
    --layer_name layer4 --backbone $backbone
done
