# Extract citation order from aux file
citations_order = []
with open('main.aux', 'r') as f:
    for line in f:
        if '\\citation{' in line:
            cites = line.split('{')[1].split('}')[0].split(',')
            for c in cites:
                if c and c not in citations_order:
                    citations_order.append(c)

# Get citation numbers from bibcite
cite_numbers = {}
with open('main.aux', 'r') as f:
    for line in f:
        if '\\bibcite{' in line:
            parts = line.split('{')
            name = parts[1].split('}')[0]
            num = parts[2].split('}')[0]
            cite_numbers[name] = int(num)

# Check order
print("First appearance order of citations:")
print("Citation Name -> [Number in Bibliography]")
print("-" * 50)
for i, cite in enumerate(citations_order, 1):
    if cite in cite_numbers:
        num = cite_numbers[cite]
        print(f"{i:3d}. {cite:35s} -> [{num:2d}]")
    
# Check if they're sequential
print("\n" + "=" * 50)
print("ISSUES FOUND:")
print("=" * 50)
last_num = 0
issues = []
for i, cite in enumerate(citations_order):
    if cite in cite_numbers:
        num = cite_numbers[cite]
        if num < last_num:
            issues.append(f"Citation [{num}] ({cite}) appears after [{last_num}]")
        last_num = max(last_num, num)

if issues:
    for issue in issues:
        print(f"⚠️  {issue}")
else:
    print("✓ All citations appear in sequential order!")
