# LaTeX Compilation Instructions

## Required Setup

This document requires the TeX Live installation available through the module system.

## Compilation Steps

1. **Load the TeX Live module:**
   ```bash
   module load texlive/20200406
   ```

2. **Compile the main document:**
   ```bash
   pdflatex main.tex
   ```

3. **Run BibTeX for bibliography (if needed):**
   ```bash
   bibtex main
   ```

4. **Run pdflatex again (twice) to resolve cross-references:**
   ```bash
   pdflatex main.tex
   pdflatex main.tex
   ```

## Alternative: Single Command Compilation

After loading the module, you can use:
```bash
module load texlive/20200406
pdflatex main.tex && bibtex main && pdflatex main.tex && pdflatex main.tex
```

## Troubleshooting

- **If `pdflatex` is not found:** Make sure you've loaded the module first with `module load texlive/20200406`
- **If module is not available:** Check available modules with `module avail | grep tex`
- **For missing citations:** Make sure `references.bib` is in the same directory and run the full compilation sequence including bibtex

## Notes

- The conda environment's TeX installation (`/home/users/astar/gis/linxy/scratch/miniforge3/envs/llm/`) is missing format files and should not be used
- Always use the system's TeX Live module for reliable compilation
- The document uses the `agents4science_2025` style file which must be present in the same directory