_base_ = 'mmpretrain::_base_/default_runtime.py'

custom_imports = dict(imports=['projects.ViMoE'], allow_failed_imports=False)

pretrained = 'data/pretrained/dinov2/vit-small-p14_dinov2-pre_3rdparty_20230426-5641ca5a.pth'

num_layers = 12
layer_decay_rate = 0.65

moe_cfgs = {
    10: 8,
    11: 8,
}
layer_cfgs = [
    dict(
        n_shared_experts=1,
        n_routed_experts=moe_cfgs[i],
        num_experts_per_tok=1,
        moe_type='image',
        norm_topk_prob=False,
        aux_loss_alpha=0.01 / (layer_decay_rate**(num_layers - i)),
        use_seq_aux=False,
    ) if i in moe_cfgs.keys() else
    dict(
        n_shared_experts=1,
        n_routed_experts=0,
        num_experts_per_tok=0,
    ) for i in range(num_layers)
]
# model settings
model = dict(
    type='ImageClassifier',
    backbone=dict(
        type='MoEVisionTransformer',
        arch=dict(
            embed_dims=384,
            num_layers=num_layers,
            num_heads=6,
            feedforward_channels=384 * 4),
        img_size=224,
        patch_size=14,
        drop_path_rate=0.1,
        layer_scale_init_value=1e-5,
        layer_cfgs=layer_cfgs,
        init_cfg=dict(
            type='Pretrained', checkpoint=pretrained, prefix='backbone')),
    neck=None,
    head=dict(
        type='VisionTransformerClsHead',
        num_classes=1000,
        in_channels=384,
        loss=dict(
            type='LabelSmoothLoss', label_smooth_val=0.1, mode='original'),
        init_cfg=[dict(type='TruncNormal', layer='Linear', std=2e-5)]),
    train_cfg=dict(augments=[
        dict(type='Mixup', alpha=0.8),
        dict(type='CutMix', alpha=1.0)
    ]))

# dataset settings
dataset_type = 'ImageNet'
data_preprocessor = dict(
    num_classes=1000,
    # RGB format normalization parameters
    mean=[123.675, 116.28, 103.53],
    std=[58.395, 57.12, 57.375],
    # convert image from BGR to RGB
    to_rgb=True,
)

bgr_mean = data_preprocessor['mean'][::-1]
bgr_std = data_preprocessor['std'][::-1]
image_size = 224

train_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(
        type='RandomResizedCrop',
        scale=image_size,
        backend='pillow',
        interpolation='bicubic'),
    dict(type='RandomFlip', prob=0.5, direction='horizontal'),
    dict(
        type='RandAugment',
        policies='timm_increasing',
        num_policies=2,
        total_level=10,
        magnitude_level=9,
        magnitude_std=0.5,
        hparams=dict(
            pad_val=[round(x) for x in bgr_mean], interpolation='bicubic')),
    dict(
        type='RandomErasing',
        erase_prob=0.25,
        mode='rand',
        min_area_ratio=0.02,
        max_area_ratio=1 / 3,
        fill_color=bgr_mean,
        fill_std=bgr_std),
    dict(type='PackInputs'),
]

test_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(
        type='ResizeEdge',
        scale=256,
        edge='short',
        backend='pillow',
        interpolation='bicubic'),
    dict(type='CenterCrop', crop_size=image_size),
    dict(type='PackInputs'),
]

train_dataloader = dict(
    batch_size=256,
    num_workers=10,
    dataset=dict(
        type=dataset_type,
        data_root='data/imagenet',
        ann_file='meta/train.txt',
        data_prefix='train',
        pipeline=train_pipeline),
    sampler=dict(type='DefaultSampler', shuffle=True),
)

val_dataloader = dict(
    batch_size=256,
    num_workers=10,
    dataset=dict(
        type=dataset_type,
        data_root='data/imagenet',
        ann_file='meta/val.txt',
        data_prefix='val',
        pipeline=test_pipeline),
    sampler=dict(type='DefaultSampler', shuffle=False),
)
val_evaluator = dict(type='Accuracy', topk=(1, 5))

# If you want standard test, please manually configure the test dataset
test_dataloader = val_dataloader
test_evaluator = val_evaluator

# optimizer
optim_wrapper = dict(
    optimizer=dict(
        type='AdamW', lr=1e-4, weight_decay=0.05, betas=(0.9, 0.999)),
    constructor='CustomOptimWrapperConstructor',
    paramwise_cfg=dict(
        layer_decay_rate=layer_decay_rate,
        custom_keys={
            '.ln': dict(decay_mult=0.0),
            '.bias': dict(decay_mult=0.0),
            '.cls_token': dict(decay_mult=0.0),
            '.pos_embed': dict(decay_mult=0.0),
        },
    ))

# learning policy
param_scheduler = [
    # warm up learning rate scheduler
    dict(
        type='LinearLR',
        start_factor=1e-4,
        by_epoch=True,
        begin=0,
        end=20,
        convert_to_iter_based=True),
    dict(
        type='CosineAnnealingLR',
        by_epoch=True,
        begin=20,
        eta_min=1e-6,
        convert_to_iter_based=True)
]

# runtime settings
default_hooks = dict(
    # save checkpoint per epoch.
    checkpoint=dict(
        type='CheckpointHook',
        interval=1,
        max_keep_ckpts=2,
        save_best='auto',
        rule='greater'
    ))

# train, val, test setting
train_cfg = dict(by_epoch=True, max_epochs=200, val_interval=1)
val_cfg = dict()
test_cfg = dict()

# NOTE: `auto_scale_lr` is for automatically scaling LR,
# based on the actual training batch size.
auto_scale_lr = dict(base_batch_size=1024)
