from functools import partial
from smac.env import MultiAgentEnv, StarCraft2Env
import sys
import os

from .grid_mpe import DenseTwoPlayerNavigationMPEEnv

def env_fn(env, **kwargs) -> MultiAgentEnv:
    return env(**kwargs)


REGISTRY = {}
REGISTRY["sc2"] = partial(env_fn, env=StarCraft2Env)
REGISTRY["dense_p2_navigation"] = partial(env_fn, env=DenseTwoPlayerNavigationMPEEnv)

if sys.platform == "linux":
    os.environ.setdefault("SC2PATH",
                          os.path.join(os.getcwd(), "3rdparty", "StarCraftII"))
