#### whole task encoder
WHOLE_REGISTRY = {}
from .whole import ForwardModelEncoder
WHOLE_REGISTRY["forward_model"] = ForwardModelEncoder

#### encoder
ENC_REGISTRY = {}
## single task
from .encoders import AttnEncoder
from .encoders import PoolingEncoder
from .encoders import PoolingMPEEncoder
from .encoders import PoolingNaviEncoder
from .encoders import MLPNaviEncoder
ENC_REGISTRY["attn"] = AttnEncoder
ENC_REGISTRY["pooling"] = PoolingEncoder
ENC_REGISTRY["pooling_mpe"] = PoolingMPEEncoder
ENC_REGISTRY["pooling_navi"] = PoolingNaviEncoder
ENC_REGISTRY["mlp_navi"] = MLPNaviEncoder

## multi task
from .encoders import MultiTaskPoolingEncoder
from .encoders import MultiTaskPoolingMPEEncoder
from .encoders import MultiTaskPoolingNaviEncoder
from .encoders import MultiTaskMLPNaviEncoder
ENC_REGISTRY["mt_pooling"] = MultiTaskPoolingEncoder
ENC_REGISTRY["mt_pooling_mpe"] = MultiTaskPoolingMPEEncoder
ENC_REGISTRY["mt_pooling_navi"] = MultiTaskPoolingNaviEncoder
ENC_REGISTRY["mt_mlp_navi"] = MultiTaskMLPNaviEncoder

#### decoder
DEC_REGISTRY = {}
from .decoders import MLPDecoder
DEC_REGISTRY["mlp"] = MLPDecoder