# llm-class-fairness

- Perform ablations on loss/ppl vs. weight decay / learning rate
- See how it impacts language performances at a per token granularity

## Requirements

Python 3.10+

```bash
conda create --name llm-wd python=3.10
conda activate llm-wd
pip install -r requirements.txt
pip install -e .
```

## Run your experiment

Simply run the following script;
```bash
$ python train.py # --options
```

For now you can choose the following options;
```bash
--backbone # model architecture
--max-length # LLM context length
--max-training-steps # num training steps
--logging-steps # frequency of wandb logs
--vocab-size # max BPE vocab size
--dataset
--per-device-batch-size
--weight-decay
--learning-rate
```

## Run slurm batches
Use the slurm launched script;
```bash
sbatch train.sh
```
Then inspect runs status with;
```bash
squeue -u $USER
```

## Retrieve wandb logs
You can use the [retrieve.ipynb](retrieve.ipynb) notebook for analysis

