#!/bin/bash

mkdir -p slurmout

SEED=1
MODEL="apple/OpenELM-270M"
DATASET="imdb"
weight_decays=(0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0)

WEIGHT_DECAY=${weight_decays[$SLURM_ARRAY_TASK_ID]}

cd SOMEWHERE
eval "$(conda shell.bash hook)"
conda activate llm-wd
srun python train.py \
    --weight-decay $WEIGHT_DECAY \
    --seed $SEED \
    --backbone $MODEL \
    --dataset $DATASET \
    --per-device-batch-size 64 \
    --gradient-accumulation-steps 1 \
    --max-length 128 \
    --save-last-ckpt-to-disk True \
    --generate-samples 0