#!/bin/bash

mkdir -p slurmout

# Define weight decay values
weight_decays=(0.0 0.1 0.3 0.5 1.0 2.0)
n_seeds=5
base=1

# Compute the weight decay index and seed index based on SLURM_ARRAY_TASK_ID
weight_decay_index=$((SLURM_ARRAY_TASK_ID / 5))
seed_index=$((SLURM_ARRAY_TASK_ID % n_seeds))

# Select the weight decay value and seed based on the computed indices
WEIGHT_DECAY=${weight_decays[$weight_decay_index]}
SEED=$((base + seed_index))

echo "Running training with weight decay: $WEIGHT_DECAY and seed: $SEED"

# Change to the working directory
cd SOMEWHERE

# Initialize conda (important for SLURM scripts)
eval "$(conda shell.bash hook)"

# Activate the conda environment
conda activate llm-wd

# Dynamically set the SLURM output and error filenames with weight decay and seed
export SLURM_OUTPUT="slurmout/llm_wd_fairness_wd${WEIGHT_DECAY}_sd${SEED}_%A_%a.out"
export SLURM_ERROR="slurmout/llm_wd_fairness_wd${WEIGHT_DECAY}_sd${SEED}_%A_%a.err"

# Redirect SLURM output and error to the dynamically created filenames
srun --output=$SLURM_OUTPUT --error=$SLURM_ERROR python train.py --weight-decay $WEIGHT_DECAY --seed $SEED
