#!/bin/bash
set -ex

POLICY_LOGTSP_CITY_NUM=5
TSP_CITY_NUM=5
CKPT_PATH="TSP5(DDP-10000)_80_504_6_5/best/0.84_seed42_epoch140.pt"
PROMPT_STRATEGY="stochastic_subseq;moving_prompt"
SEEDS=(42 43 44 45 46)
#ENVS=("Env_01BP_V1" "Env_TSP_V2")
ENVS=("Env_TSP_V2" )
REGEN_TIMES=5
EVAL_ITERS_COP=0    # 设0则用整个评估问题集
EVAL_ITERS_RL=5
EVAL_BATCH_NUM=0    # 设0则用整个验证集
EVAL_BATCH_SIZE=100

export LD_LIBRARY_PATH=/home/tim/anaconda3/envs/project/lib

python ./evaluate.py \
    --ckpt-path $CKPT_PATH \
    --seeds "${SEEDS[@]}" \
    --eval-iters-COP $EVAL_ITERS_COP \
    --eval-iters-RL $EVAL_ITERS_RL \
    --regen-times $REGEN_TIMES \
    --policy-logger $POLICY_LOGGER \
    --prompt-strategy $PROMPT_STRATEGY \
    --eval-envs "${ENVS[@]}" \
    --eval-batch-size $EVAL_BATCH_SIZE\
    --eval-batch-num $EVAL_BATCH_NUM \
    --tsp-city-num $TSP_CITY_NUM
    