#!/bin/bash
set -ex

POLICY_LOGGER="False"
TRAINDATA_LOGGER="False"
USE_PROMPT="True"
USE_MEM="True"
DATA_NUM=1000000

TSP_CITY_NUM=50
#CKPT_PATH="TSP5(DDP-10000)_80_504_6_5/best/0.84_seed42_epoch140.pt"
SNAPSHOT_PATH="TSP$TSP_CITY_NUM($DATA_NUM)-2_500_768_12_10/snapshot_seed42.pt"
PROMPT_STRATEGY="stochastic_subseq;moving_prompt"
SEEDS=(42 43 44)
DEVICE=(5 6)
#ENVS=("Env_01BP_V1" "Env_TSP_V2")
ENVS=("Env_TSP_V2" )
REGEN_TIMES=5

EVAL_PROBLEM_SET="eval"   # "eval" or "train_eval" 
EVAL_ITERS_COP=10000             # 设0则用整个评估问题集
EVAL_ITERS_RL=5

BATCH_SIZE=100
BATCH_NUM=10                     # 设0则用整个训练集
EVAL_BATCH_SIZE=100
EVAL_BATCH_NUM=10                # 设0则用整个验证集

export LD_LIBRARY_PATH=/home/tim/anaconda3/envs/project/lib

CUDA_VISIBLE_DEVICES=$(IFS=, ; echo "${DEVICE[*]}") torchrun --standalone --nproc_per_node=gpu --master_port=29500 ./DDP_evaluate.py \
    --snapshot-path $SNAPSHOT_PATH \
    --seeds "${SEEDS[@]}" \
    --eval-problem-set $EVAL_PROBLEM_SET \
    --eval-iters-COP $EVAL_ITERS_COP \
    --eval-iters-RL $EVAL_ITERS_RL \
    --regen-times $REGEN_TIMES \
    --policy-logger $POLICY_LOGGER \
    --traindata-logger $TRAINDATA_LOGGER \
    --use-mem $USE_MEM \
    --use-prompt $USE_PROMPT \
    --prompt-strategy $PROMPT_STRATEGY \
    --batch-size $BATCH_SIZE\
    --batch-num $BATCH_NUM \
    --eval-envs "${ENVS[@]}" \
    --eval-batch-size $EVAL_BATCH_SIZE\
    --eval-batch-num $EVAL_BATCH_NUM \
    --tsp-city-num $TSP_CITY_NUM
    