import os
import sys
base_path = os.path.abspath(os.path.join(os.path.dirname(__file__), '../../../..'))
sys.path.append(base_path)

import numpy as np
from utils.COP_slover import knapsack_dp
from data.used._raw.bp.gen_bp import MAX_ITEM_VOLUME, MAX_CAPACITY
import time
from tqdm import tqdm

if __name__ == "__main__":
    # 设置参数
    item_num = 20
    data_num = 10000

    process_data = []
    rng = np.random.RandomState(42)
    for i in range(data_num):
        values = rng.randint(2, MAX_ITEM_VOLUME[item_num], item_num)              # 随机生成物品价值
        volumes = values + 0.5*(values * rng.choice([-1, 1], size=(item_num,)))   # 物品体积基于价值生成，总体呈正相关   
        volumes = volumes.astype(np.int32)
        assert volumes.min() > 0        
        capacity = MAX_CAPACITY[item_num]
        process_data.append((capacity, values, volumes))          

    start = time.time()
    with tqdm(total=data_num, desc=f'Speed Testing') as pbar:
        for capacity, values, volumes in process_data:
            value, real_answer = knapsack_dp(capacity, volumes, values)
            pbar.update()
    duration = time.time() - start
    print(duration/data_num)