import os
import sys
base_path = os.path.abspath(os.path.join(os.path.dirname(__file__), '../../../..'))
sys.path.append(base_path)

import numpy as np
from utils.COP_slover import CVRP_lkh
from data.used._raw.cvrp.gen_cvrp import CAPACITIES
import time
from tqdm import tqdm

if __name__ == "__main__":
    # 设置参数
    node_num = 20                       # TSP城市数量
    data_distribution = 'uniform'       # TSP城市分布类型
    data_num = 100

    process_data = []
    rng = np.random.RandomState(42)
    for i in range(data_num):
        pos_depot = rng.uniform(0, 1, size=(2, ))
        pos_node = rng.uniform(0, 1, size=(node_num, 2))
        demand = rng.randint(1, 10, size=(node_num, ))
        capacity_left = CAPACITIES[node_num]
        process_data.append((pos_depot.tolist(), pos_node.tolist(), demand.tolist(), capacity_left))        

    start = time.time()
    with tqdm(total=data_num, desc=f'Speed Testing') as pbar:
        for pos_depot, pos_node, demand, capacity_left in process_data:
            cost, real_answer, _ = CVRP_lkh(pos_depot, pos_node, demand, capacity_left)
            pbar.update()
    duration = time.time() - start
    print(duration/data_num)