import os
import sys
base_path = os.path.abspath(os.path.join(os.path.dirname(__file__), '../../../..'))
sys.path.append(base_path)

import numpy as np
import matplotlib.pyplot as plt
from utils.COP_slover import TSP_lkh, TSP_gurobi
from sklearn.datasets import make_blobs, make_circles, make_moons
from utils.utils import create_folder_overwrite_if_exist, create_folder_if_not_exist, load_existing_raw_data, merge_to_dataset
from environment.used.BaseEnv_COP import RawData
import multiprocessing
import pickle
import time
from tqdm import tqdm
from data.used._raw.tsp.gen_tsp import generate_tsp_data

if __name__ == "__main__":
    # 设置参数
    node_num = 20                       # TSP城市数量
    data_distribution = 'uniform'       # TSP城市分布类型
    data_num = 1000
    process_data = generate_tsp_data(seed=42, dataset_size=data_num, tsp_size=node_num, distribution=data_distribution)

    start = time.time()
    with tqdm(total=data_num, desc=f'TSP Speed Testing') as pbar:
        for i, city_pos in enumerate(process_data):
            #cost, answer = TSP_lkh(np.array(city_pos, np.float32), l_opt_limit=6,) 
            cost, answer = TSP_gurobi(np.array(city_pos, np.float32), threads=1000,  gap=0.1) 
            pbar.update()
    duration = time.time() - start
    print(duration/data_num)