#include "LKH.h"
#include "Genetic.h"
#include "BIT.h"

/*
 * This file contains the main function of the program.
 */



int main(int argc, char* argv[])
{
    GainType Cost, OldOptimum;
    double Time, LastTime;
    Node* N;
    int i;

    /* Read the specification of the problem */
    //if (argc >= 2)
    //    ParameterFileName = argv[1];
    FILE* f_par;
    FILE* f_vrp;
    char* a;
    char* b;
    f_par = fopen("f_par", "w+");
    f_vrp = fopen("f_vrp", "w+");

    /*a = "SPECIAL\nPROBLEM_FILE = -\nOUTPUT_TOUR_FILE=../outputtour\n";
    b = "NAME : xxx\nTYPE : ACVRP\nDIMENSION : 50\nEDGE_WEIGHT_TYPE : EXPLICIT\nEDGE_WEIGHT_FORMAT : FULL_MATRIX\nCAPACITY : 100000\nVEHICLES : 49\nEDGE_WEIGHT_SECTION\n        323 325 316 289 252 295 238 316 299 316 389 346 342 295 335 343 306 317 341 394 320 303 309 316 283 308 334 329 285 352 446 350 348 307 342 306 378 340 343 298 341 346 379 296 344 308 344 297 298 345\n302 320 335 339 290 354 376 305 347 273 304 316 321 345 341 353 393 259 302 383 377 298 389 353 349 372 349 345 334 378 303 355 293 326 322 357 252 306 302 311 312 379 346 365 331 380 331 383 291 310\n257 379 303 330 364 331 403 392 369 401 322 419 325 340 383 416 412 279 338 330 278 337 321 327 338 356 356 378 388 305 327 284 420 272 288 347 279 352 280 314 292 291 322 312 410 330 345 321 373 326\n295 290 321 350 374 316 292 276 368 334 400 293 393 320 396 348 324 282 333 324 325 314 339 378 293 280 306 321 327 326 317 385 239 292 355 378 381 350 386 441 328 256 353 315 346 341 294 322 301 408\n362 263 342 308 319 291 338 337 363 341 388 346 278 363 323 347 253 293 355 281 353 269 318 356 336 366 386 331 313 345 361 298 274 320 296 294 330 314 242 306 331 317 318 371 341 258 295 268 361 313\n346 360 293 344 317 319 319 349 355 382 298 293 323 351 372 312 337 270 376 287 335 331 299 379 382 349 342 353 299 361 357 316 365 375 245 281 276 377 276 296 315 291 346 354 332 263 348 343 379 303\n339 280 361 316 325 303 387 339 255 285 342 392 367 415 303 339 257 386 336 325 408 333 360 255 276 335 323 342 386 318 350 272 342 360 363 312 393 339 334 326 406 378 314 316 311 376 246 292 317 373\n305 395 290 365 286 285 343 348 332 457 313 285 299 326 257 334 458 357 352 354 291 326 296 344 278 343 356 338 340 342 384 336 337 307 355 330 361 320 277 337 326 363 323 333 332 336 270 353 286 333\n308 328 297 246 312 309 345 413 330 297 319 300 313 395 357 362 300 448 317 339 383 348 338 336 365 358 336 388 304 304 399 293 296 267 301 231 403 386 370 335 338 294 318 252 338 324 349 319 394 385\n301 308 311 330 384 430 363 367 358 313 333 263 396 268 348 212 336 361 309 295 376 341 367 306 308 329 351 315 320 353 328 327 367 304 395 409 316 307 374 317 366 296 310 308 281 342 349 287 274 346\n351 325 358 403 326 331 358 306 312 347 338 374 332 326 279 350 336 388 308 319 369 388 318 315 337 393 328 433 291 317 276 352 297 416 346 351 348 300 398 285 369 366 335 318 340 376 323 397 352 334\n280 330 297 306 393 335 293 383 386 323 462 333 355 326 296 280 277 392 347 360 413 327 278 365 309 439 339 321 319 325 279 337 359 358 280 342 387 284 330 323 377 301 314 284 280 319 384 284 368 397\n382 320 343 329 320 326 297 388 369 280 343 296 276 382 298 298 344 303 354 351 380 313 266 332 271 354 308 323 320 295 292 315 284 272 350 332 322 321 358 316 315 297 314 314 312 326 344 308 308 293\n305 307 381 375 335 424 291 373 396 313 284 346 320 262 321 344 311 301 313 355 325 385 291 271 343 404 307 331 329 282 303 301 351 351 352 404 369 357 337 278 340 312 309 312 316 322 355 303 252 334\n369 288 342 310 311 355 339 328 369 304 275 305 354 353 319 323 318 368 389 275 302 350 425 380 375 313 314 355 308 380 305 329 340 316 352 286 341 402 337 363 317 242 412 335 300 335 325 385 336 382\n236 353 317 289 274 291 314 293 332 336 334 334 346 358 371 373 322 323 294 320 318 353 344 304 381 279 319 381 330 349 332 314 302 337 273 354 304 260 297 418 318 372 290 347 359 318 283 280 347 380\n300 250 328 293 331 414 278 329 302 341 317 290 296 302 328 375 335 257 269 349 355 317 395 330 314 306 391 384 278 333 362 345 303 300 360 343 309 285 321 298 333 383 323 341 271 371 277 399 316 374\n360 309 287 376 350 396 340 382 316 370 394 317 316 303 381 305 280 281 409 287 402 324 279 359 338 323 322 385 320 295 308 364 293 348 334 318 335 369 324 301 364 336 352 286 340 312 338 335 275 332\n438 311 316 365 368 328 349 316 364 369 301 271 338 341 313 305 270 333 325 303 295 349 311 321 353 294 330 297 325 379 304 321 406 337 431 358 315 393 354 293 369 357 278 330 327 267 357 318 377 309\n361 364 276 363 264 385 288 295 321 357 275 334 320 274 441 351 234 292 295 364 396 391 298 351 266 409 324 353 384 369 329 377 297 335 306 262 280 330 364 410 335 349 325 313 325 330 333 346 277 388\n322 287 411 309 323 300 359 265 336 288 382 325 309 288 373 296 246 357 288 313 335 410 384 353 330 310 299 326 416 329 326 287 336 367 312 352 322 328 381 317 307 323 292 361 350 290 290 343 299 355\n323 322 242 361 344 294 311 373 341 279 328 320 261 334 308 313 298 378 308 395 345 303 340 290 296 366 313 297 326 316 349 305 340 409 333 298 342 404 295 327 307 324 390 320 274 294 364 274 373 365\n373 349 311 318 319 333 347 263 353 296 352 359 332 318 326 337 334 408 331 400 335 310 311 293 311 358 350 376 397 367 354 387 298 319 283 321 234 318 396 320 343 289 336 394 334 342 381 375 374 319\n330 259 306 325 337 328 327 362 434 330 279 325 332 349 289 360 319 353 337 400 356 305 382 251 295 329 342 307 363 315 303 349 366 342 302 334 431 328 361 355 327 369 344 298 299 331 309 315 341 294\n377 333 316 328 364 301 428 314 375 396 327 354 357 306 308 418 321 408 312 328 375 329 321 345 429 410 323 344 326 385 293 334 360 320 297 359 326 372 371 373 277 364 269 291 342 315 369 308 311 313\n360 330 331 350 341 340 258 380 334 367 318 262 333 278 359 365 344 344 240 314 280 362 361 355 357 321 344 326 354 274 217 351 293 358 331 314 372 304 336 331 340 356 405 360 297 341 305 332 321 358\n335 389 290 299 320 350 296 369 348 343 417 324 405 379 316 375 259 327 378 400 308 308 267 306 333 385 371 354 312 406 439 353 228 363 333 302 372 296 329 269 269 369 400 347 329 389 317 329 354 262\n325 324 335 250 322 351 367 376 333 375 390 324 391 342 315 329 330 372 305 295 324 392 304 328 286 356 350 343 379 325 319 351 326 321 321 290 388 338 331 297 341 257 304 384 341 310 371 361 343 333\n309 323 371 349 296 301 323 325 361 286 300 366 326 340 314 352 292 320 357 344 258 356 401 337 271 307 378 325 332 366 349 230 317 314 310 389 336 347 367 333 297 358 374 300 320 311 362 309 399 393\n300 367 370 285 359 339 300 340 285 203 320 339 313 354 291 338 407 340 392 304 314 326 359 399 344 265 416 375 407 342 299 330 380 334 329 311 375 341 296 315 363 410 321 274 321 339 380 262 318 297\n364 334 291 342 386 343 328 411 317 368 365 302 367 362 334 385 365 286 396 331 354 362 283 320 323 314 340 393 312 336 386 323 335 348 346 289 329 365 291 380 287 329 368 307 302 331 344 354 303 279\n302 379 365 281 341 322 379 330 346 312 337 352 266 370 302 309 310 385 333 406 289 366 249 359 329 412 320 297 252 296 363 319 300 317 348 346 323 346 307 321 332 310 292 278 332 382 270 352 382 340\n356 292 282 289 323 333 306 377 301 411 365 325 265 344 302 289 309 307 346 259 309 335 394 370 325 287 336 346 364 362 348 282 290 363 251 341 395 308 393 374 297 331 341 304 275 298 340 341 293 286\n358 395 318 375 303 421 316 337 337 341 362 266 356 354 302 405 309 355 378 344 342 381 303 315 344 353 306 376 395 337 330 343 296 359 325 322 372 349 361 357 293 345 325 334 235 348 284 349 338 303\n337 358 359 331 318 348 302 375 340 338 324 338 304 338 426 323 339 397 348 260 378 321 318 349 393 311 406 354 306 274 400 382 323 352 326 337 368 430 374 340 336 329 376 408 332 321 322 344 377 291\n319 263 300 271 344 382 344 301 277 286 387 372 329 358 336 332 309 285 383 358 355 260 399 311 296 338 310 345 314 273 387 284 419 352 264 321 299 379 313 332 381 435 312 338 257 408 349 309 284 306\n338 255 397 278 307 364 313 373 353 331 328 330 371 320 330 357 345 311 371 307 296 293 363 295 355 248 304 315 371 345 351 356 363 335 282 330 246 316 363 267 291 316 375 310 376 342 321 391 361 306\n401 309 355 381 332 366 291 334 311 340 311 360 368 325 380 275 263 314 369 340 369 348 365 384 373 284 327 379 294 336 338 246 338 323 350 378 283 333 261 372 350 347 325 358 330 302 327 314 266 383\n343 255 281 322 319 348 332 356 393 257 351 328 303 280 353 263 329 339 305 297 322 370 404 316 377 257 370 355 269 331 396 300 348 310 347 309 391 350 297 350 273 345 368 290 404 261 269 345 265 312\n359 327 355 354 416 372 315 342 392 361 373 371 311 341 361 337 328 276 413 306 376 290 355 259 274 356 349 325 319 337 352 339 344 268 278 371 279 306 366 349 310 255 339 395 335 347 356 283 343 287\n229 364 377 332 394 326 330 297 354 302 335 304 398 325 334 380 368 328 314 308 286 319 350 376 328 329 389 358 314 361 333 310 371 281 299 367 306 312 257 317 381 285 368 332 337 319 328 299 306 349\n276 368 307 338 316 315 340 350 359 331 443 381 350 350 298 385 292 350 348 326 315 342 284 377 305 325 338 307 297 357 361 340 294 268 279 357 262 356 321 345 306 320 352 330 373 282 389 298 332 373\n284 319 355 417 326 311 396 318 339 348 319 325 326 291 359 295 323 338 309 330 325 384 335 376 234 300 324 324 349 316 346 293 350 322 302 379 371 365 393 303 385 349 306 395 330 286 376 356 404 323\n344 297 376 274 294 333 270 351 332 338 364 384 326 383 343 270 301 367 308 398 371 390 394 282 312 320 326 301 323 316 392 335 357 274 362 283 255 427 332 340 289 258 310 341 390 304 265 334 313 291\n341 356 423 339 376 290 309 347 312 300 409 284 292 363 340 316 323 333 286 340 299 334 346 321 278 288 439 302 345 363 388 405 317 315 300 319 327 272 270 372 319 329 326 305 382 380 388 343 308 320\n382 291 371 327 278 289 353 249 317 277 369 289 320 294 363 429 374 301 274 330 445 273 365 328 275 330 297 274 326 303 356 367 307 402 324 255 271 378 382 364 379 337 248 371 360 301 357 403 345 370\n383 316 303 377 321 348 348 388 324 349 316 368 399 280 328 292 390 358 395 302 414 396 327 308 327 347 295 255 337 330 380 316 290 391 296 328 392 298 352 349 332 306 342 330 391 362 313 325 350 365\n332 298 346 343 363 373 363 322 312 356 416 324 360 299 348 353 311 303 338 391 335 363 370 328 402 367 350 314 327 293 333 363 301 348 356 401 331 283 349 343 347 280 343 287 289 390 314 363 269 302\n349 420 360 268 387 325 346 325 306 334 317 363 280 444 280 307 344 346 358 365 277 360 335 334 378 334 292 375 264 346 382 310 352 344 388 333 420 278 369 351 357 259 336 352 314 345 301 304 367 310\n318 320 322 379 393 333 325 271 343 288 311 279 343 293 353 387 353 292 294 356 283 314 306 299 378 328 383 340 324 358 348 314 294 405 303 374 327 400 347 370 313 361 318 354 339 376 371 347 278 346\nDEMAND_SECTION\n1 0\n2 20000\n3 30000\n4 40000\n5 50000\n6 40000\n7 30000\n8 20000\n9 10000\n10 50000\n11 60000\n12 20000\n13 30000\n14 40000\n15 50000\n16 40000\n17 30000\n18 20000\n19 10000\n20 50000\n21 60000\n22 20000\n23 30000\n24 40000\n25 50000\n26 40000\n27 30000\n28 20000\n29 10000\n30 50000\n31 60000\n32 20000\n33 30000\n34 40000\n35 50000\n36 40000\n37 30000\n38 20000\n39 10000\n40 50000\n41 60000\n42 20000\n43 30000\n44 40000\n45 50000\n46 40000\n47 30000\n48 20000\n49 10000\n50 50000\nDEPOT_SECTION\n1\nEOF\n";*/
    if (argc >= 2) {
        a = argv[1];
        b = argv[2];
    }
    else {
        printff("Only $d parameters are given", argv[0]);
        exit(1);
    }
    replacechar(a, '`', '\n');
    replacechar(b, '`', '\n');
    fputs(a, f_par);
    fputs(b, f_vrp);
    rewind(f_par);
    rewind(f_vrp);
    ReadParameters(f_par);
    StartTime = LastTime = GetTime();
    MaxMatrixDimension = 20000;
    MergeWithTour =
        Recombination == GPX2 ? MergeWithTourGPX2 :
        Recombination == CLARIST ? MergeWithTourCLARIST :
        MergeWithTourIPT;
    ReadProblem(f_vrp);
    if (SubproblemSize > 0) {
        if (DelaunayPartitioning)
            SolveDelaunaySubproblems();
        else if (KarpPartitioning)
            SolveKarpSubproblems();
        else if (KCenterPartitioning)
            SolveKCenterSubproblems();
        else if (KMeansPartitioning)
            SolveKMeansSubproblems();
        else if (RohePartitioning)
            SolveRoheSubproblems();
        else if (MoorePartitioning || SierpinskiPartitioning)
            SolveSFCSubproblems();
        else
            SolveTourSegmentSubproblems();
        return EXIT_SUCCESS;
    }
    AllocateStructures();
    if (ProblemType == TSPTW)
        TSPTW_Reduce();
    if (ProblemType == VRPB || ProblemType == VRPBTW)
        VRPB_Reduce();
    if (ProblemType == PDPTW)
        PDPTW_Reduce();
    CreateCandidateSet();
    InitializeStatistics();

    if (Norm != 0 || Penalty) {
        Norm = 9999;
        BestCost = PLUS_INFINITY;
        BestPenalty = CurrentPenalty = PLUS_INFINITY;
    }
    else {
        /* The ascent has solved the problem! */
        Optimum = BestCost = (GainType)LowerBound;
        UpdateStatistics(Optimum, GetTime() - LastTime);
        RecordBetterTour();
        RecordBestTour();
        CurrentPenalty = PLUS_INFINITY;
        BestPenalty = CurrentPenalty = Penalty ? Penalty() : 0;
        WriteTour(OutputTourFileName, BestTour, BestCost);
        WriteTour(TourFileName, BestTour, BestCost);
        Runs = 0;
    }

    /* Find a specified number (Runs) of local optima */

    for (Run = 1; Run <= Runs; Run++) {
        LastTime = GetTime();
        if (LastTime - StartTime >= TotalTimeLimit) {
            if (TraceLevel >= 1)
                printff("*** Time limit exceeded ***\n");
            Run--;
            break;
        }
        Cost = FindTour();      /* using the Lin-Kernighan heuristic */
        if (MaxPopulationSize > 1 && !TSPTW_Makespan) {
            /* Genetic algorithm */
            int i;
            for (i = 0; i < PopulationSize; i++) {
                GainType OldPenalty = CurrentPenalty;
                GainType OldCost = Cost;
                Cost = MergeTourWithIndividual(i);
                if (TraceLevel >= 1 &&
                    (CurrentPenalty < OldPenalty ||
                        (CurrentPenalty == OldPenalty && Cost < OldCost))) {
                    if (CurrentPenalty)
                        printff("  Merged with %d: Cost = " GainFormat "_"
                            GainFormat, i + 1, CurrentPenalty, Cost);
                    else
                        printff("  Merged with %d: Cost = " GainFormat,
                            i + 1, Cost);
                    if (Optimum != MINUS_INFINITY && Optimum != 0) {
                        if (ProblemType != CCVRP && ProblemType != TRP &&
                            ProblemType != MLP &&
                            MTSPObjective != MINMAX &&
                            MTSPObjective != MINMAX_SIZE)
                            printff(", Gap = %0.4f%%",
                                100.0 * (Cost - Optimum) / Optimum);
                        else
                            printff(", Gap = %0.4f%%",
                                100.0 * (CurrentPenalty - Optimum) /
                                Optimum);
                    }
                    printff("\n");
                }
            }
            if (!HasFitness(CurrentPenalty, Cost)) {
                if (PopulationSize < MaxPopulationSize) {
                    AddToPopulation(CurrentPenalty, Cost);
                    if (TraceLevel >= 1)
                        PrintPopulation();
                }
                else if (SmallerFitness(CurrentPenalty, Cost,
                    PopulationSize - 1)) {
                    i = ReplacementIndividual(CurrentPenalty, Cost);
                    ReplaceIndividualWithTour(i, CurrentPenalty, Cost);
                    if (TraceLevel >= 1)
                        PrintPopulation();
                }
            }
        }
        else if (Run > 1 && !TSPTW_Makespan)
            Cost = MergeTourWithBestTour();
        if (CurrentPenalty < BestPenalty ||
            (CurrentPenalty == BestPenalty && Cost < BestCost)) {
            BestPenalty = CurrentPenalty;
            BestCost = Cost;
            RecordBetterTour();
            RecordBestTour();
            WriteTour(TourFileName, BestTour, BestCost);
        }
        OldOptimum = Optimum;
        if (!Penalty ||
            (MTSPObjective != MINMAX && MTSPObjective != MINMAX_SIZE)) {
            if (CurrentPenalty == 0 && Cost < Optimum)
                Optimum = Cost;
        }
        else if (CurrentPenalty < Optimum)
            Optimum = CurrentPenalty;
        if (Optimum < OldOptimum) {
            printff("*** New OPTIMUM = " GainFormat " ***\n", Optimum);
            if (FirstNode->InputSuc) {
                Node* N = FirstNode;
                while ((N = N->InputSuc = N->Suc) != FirstNode);
            }
        }
        Time = fabs(GetTime() - LastTime);
        UpdateStatistics(Cost, Time);
        if (TraceLevel >= 1 && Cost != PLUS_INFINITY) {
            printff("Run %d: ", Run);
            StatusReport(Cost, LastTime, "");
            printff("\n");
        }
        if (StopAtOptimum && MaxPopulationSize >= 1) {
            if (ProblemType != CCVRP && ProblemType != TRP &&
                ProblemType != MLP &&
                MTSPObjective != MINMAX &&
                MTSPObjective != MINMAX_SIZE ?
                CurrentPenalty == 0 && Cost == Optimum :
                CurrentPenalty == Optimum) {
                Runs = Run;
                break;
            }
        }
        if (PopulationSize >= 2 &&
            (PopulationSize == MaxPopulationSize ||
                Run >= 2 * MaxPopulationSize) && Run < Runs) {
            Node* N;
            int Parent1, Parent2;
            Parent1 = LinearSelection(PopulationSize, 1.25);
            do
                Parent2 = LinearSelection(PopulationSize, 1.25);
            while (Parent2 == Parent1);
            ApplyCrossover(Parent1, Parent2);
            N = FirstNode;
            do {
                if (ProblemType != HCP && ProblemType != HPP) {
                    int d = C(N, N->Suc);
                    AddCandidate(N, N->Suc, d, INT_MAX);
                    AddCandidate(N->Suc, N, d, INT_MAX);
                }
                N = N->InitialSuc = N->Suc;
            } while (N != FirstNode);
        }
        SRandom(++Seed);
    }
    //PrintStatistics();
    if (Salesmen > 1) {
        if (Dimension == DimensionSaved) {
            for (i = 1; i <= Dimension; i++) {
                N = &NodeSet[BestTour[i - 1]];
                (N->Suc = &NodeSet[BestTour[i]])->Pred = N;
            }
        }
        else {
            for (i = 1; i <= DimensionSaved; i++) {
                Node* N1 = &NodeSet[BestTour[i - 1]];
                Node* N2 = &NodeSet[BestTour[i]];
                Node* M1 = &NodeSet[N1->Id + DimensionSaved];
                Node* M2 = &NodeSet[N2->Id + DimensionSaved];
                (M1->Suc = N1)->Pred = M1;
                (N1->Suc = M2)->Pred = N1;
                (M2->Suc = N2)->Pred = M2;
            }
        }
        CurrentPenalty = BestPenalty;
        //MTSP_Report(BestPenalty, BestCost);
        MTSP_WriteSolution(MTSPSolutionFileName, BestPenalty, BestCost);
        SINTEF_WriteSolution(SINTEFSolutionFileName, BestCost);
    }
    if (ProblemType == ACVRP ||
        ProblemType == BWTSP ||
        ProblemType == CCVRP ||
        ProblemType == CTSP ||
        ProblemType == CVRP ||
        ProblemType == CVRPTW ||
        ProblemType == MLP ||
        ProblemType == M_PDTSP ||
        ProblemType == M1_PDTSP ||
        MTSPObjective != -1 ||
        ProblemType == ONE_PDTSP ||
        ProblemType == OVRP ||
        ProblemType == PDTSP ||
        ProblemType == PDTSPL ||
        ProblemType == PDPTW ||
        ProblemType == RCTVRP ||
        ProblemType == RCTVRPTW ||
        ProblemType == SOP ||
        ProblemType == TRP ||
        ProblemType == TSPTW ||
        ProblemType == VRPB ||
        ProblemType == VRPBTW || ProblemType == VRPPD) {
        //printff("Best %s solution:\n", Type);
        CurrentPenalty = BestPenalty;
        //SOP_Report(BestCost);
    }
    remove("f_par");
    remove("f_vrp");
    //system("pause");
    return EXIT_SUCCESS;
}
