Official implementation of "Scaling Continuous Latent Variable Models as Probabilistic Integral Circuits".

To use imagenet32 and imagenet64, please download them from https://image-net.org/download-images.
For each dataset, concatenate the batches as to create two pytorch uint8 tensors `train.pt` and `valid.pt`.
Place these tensors in `data/imagenet32` and `data/imagenet64`.

We report below some example experiments.

# MNIST-like datasets

    python training_pic.py  --dataset mnist  --rg QT --inner-layer cp       --k 512 --lr 0.005 --t0 500 --weight-decay 1e-2 --net-dim 256
    python training_pic.py  --dataset mnist  --rg QG --inner-layer cp       --k 512 --lr 0.005 --t0 500 --weight-decay 1e-2 --net-dim 256
    python training_pic.py  --dataset mnist  --rg QG --inner-layer tucker	--k 64  --lr 0.005 --t0 500 --weight-decay 1e-2 --net-dim 256
    
    python training_pc.py   --dataset mnist	--rg QT --inner-layer cp        --k 512 --lr 0.01
    python training_pc.py   --dataset mnist	--rg QG --inner-layer cp        --k 512 --lr 0.01
    python training_pc.py   --dataset mnist	--rg QG --inner-layer tucker	--k 64  --lr 0.01

# CIFAR
    
    python training_pic.py --dataset cifar  --rg QG --inner-layer cp --k 512 --lr 0.005 --t0 500 --weight-decay 1e-2 --ycc lossy

    python training_pc.py --dataset cifar	--rg QG --inner-layer cp --k 512 --lr 0.01 -sil --ycc lossy

# CelebA

    python training_pic.py  --dataset celeba --rg QG --inner-layer cp --k 512 --lr 0.005 --t0 500 --weight-decay 1e-2 --valid-freq 750 --ycc lossy

    python training_pc.py   --dataset celeba --rg QG --inner-layer cp --k 512 --lr 0.01 -sil --valid-freq 750 --ycc lossy
