### d=1 implementation

priv_mech=function(x,y,h,alpha){
  N=1/h
  eps=(4/alpha)*(2*rbinom(N,1,0.5)-1)*rexp(N); zeta=(4/alpha)*(2*rbinom(N,1,0.5)-1)*rexp(N)
  w=rep(0,N); z=rep(0,N)
  
  j=floor(N*x)+1
  w[j]=1; z[j]=y
  w=w+eps; z=z+zeta
  return(list(w,z))
}

all_priv_data=function(X,Y,h,alpha){
  n=length(X); N=1/h
  W=matrix(rep(0,N*n),nrow=n); Z=matrix(rep(0,N*n),nrow=n)
  for(i in 1:n){
    privatei=priv_mech(X[i],Y[i],h,alpha)
    W[i,]=privatei[[1]]; Z[i,]=privatei[[2]]
  }
  return(list(W,Z))
}


Dhats=function(t,W,Z){
  N=ncol(W); Wrev=W[t:2,]; Zrev=Z[t:2,]; W=W[1:(t-1),]; Z=Z[1:(t-1),]
  
  mu1=apply(W,2,cumsum); nu1=apply(Z,2,cumsum); threshold=log(1+1:(t-1)); ind1=(mu1>threshold)
  m1=matrix(rep(0,(t-1)*N),nrow=t-1); m2=m1
  m1[ind1]=nu1[ind1]/mu1[ind1]   # These mu and nu are actually sums of W,Z rather than averages
  
  mu2=apply(Wrev,2,cumsum); nu2=apply(Zrev,2,cumsum); ind2=(mu2>threshold)
  m2[ind2]=nu2[ind2]/mu2[ind2]; m2=m2[(t-1):1,]
  
  scales=sqrt((1:(t-1))*(t-1:(t-1))/t)
  Dhats=abs(scales*(m1-m2))
  Dhats=apply(Dhats,1,max)
  return(Dhats)
}

changepoint=function(X,Y,h,alpha,b,Nchecks){
  n=length(X)
  data=all_priv_data(X,Y,h,alpha)
  W=data[[1]]; Z=data[[2]]
  return(changepoint_from_priv(W,Z,h,b,Nchecks))
}

changepoint_from_priv=function(W,Z,h,b,Nchecks){
  n=nrow(W)
  DhatMat=matrix(rep(0,n*Nchecks),nrow=n)
  for(nchecks in 1:Nchecks){
    t=floor(nchecks*n/Nchecks)
    DhatMat[(1:(t-1)),nchecks]=Dhats(t,W,Z)
  }
  rej=(DhatMat>b)
  changeind=0
  if(sum(rej)>0){
    changeind=1
    changepoint=(which(colSums(rej)>0)[1])*n/Nchecks
    return(list(changeind,changepoint))
  }else{
    return(list(changeind,Inf))
  }
}

changepoint_tuning_single=function(W,Z,h,C,Nchecks){
  n=nrow(W)
  DhatMat=matrix(rep(0,n*Nchecks),nrow=n)
  for(nchecks in 1:Nchecks){
    t=floor(nchecks*n/Nchecks)
    DhatMat[(1:(t-1)),nchecks]=Dhats(t,W,Z)
  }
  Smat=matrix(rep(1:n,Nchecks),ncol=Nchecks)
  Tmat=(n/Nchecks)*matrix(rep(1:Nchecks,n),ncol=Nchecks,byrow=TRUE)
  Scalemat=Smat*(Tmat-Smat)/Tmat
  outofbounds=(Scalemat<=0)
  Scalemat[outofbounds]=Inf; Scalemat=sqrt(Scalemat)
  
  b=matrix(rep(Inf,n*Nchecks),ncol=n)
  b[,1:n]=sqrt(log((n/Nchecks)*(1:Nchecks))-log(gamma*h))
  b=t(b)/(alpha*h)
  b[outofbounds]=Inf
  bBase=b
  
  Nparam=length(C); rej=rep(0,Nparam)
  for(nparam in 1:Nparam){
    c=C[nparam]; b=c*bBase
    b[b>=Scalemat]=Inf
    
    check=(DhatMat>b)
    rej[nparam]=(sum(check)>0)
  }
  return(rej)
}

changepoint_tuning=function(W,Z,h,C,Nperm,Nchecks){
  n=nrow(W)
  Nparam=length(C); rej=rep(0,Nparam)
  for(nperm in 1:Nperm){
    perm=sample(n); Wperm=W[perm,]; Zperm=Z[perm,]
    rej=rej+changepoint_tuning_single(Wperm,Zperm,h,C,Nchecks)
    print(nperm)
  }
  return(rej/Nperm)
}


## Quick sanity check for Dhats function
# Looks good -- null sample (red line) is roughly constant (away from endpoints) 
# while black line peaks at Delta
n=100000; Delta=n/2; post=(Delta+1):n; h=0.2; alpha=2; kappa=1/2

X=runif(n); Y=runif(n,min=-1/2,max=1/2); Y[post]=Y[post]+kappa*((X[post]>1/2)-(X[post]<1/2))
data=all_priv_data(X,Y,h,alpha); W=data[[1]]; Z=data[[2]]
altDhats=Dhats(n,W,Z)
plot(altDhats,type="l")

X=runif(n); Y=runif(n,min=-1/2,max=1/2)
data=all_priv_data(X,Y,h,alpha); W=data[[1]]; Z=data[[2]]
lines(Dhats(n,W,Z),col=2)




## Suppose we have a privatised sample of size n from the pre-change distribution. We will use this to 
## calibrate the thresholds.
library(latex2exp)
n=10000; h=0.2; gamma=0.1; Nperm=1000; C=0.01*(200:2000); Nchecks=100; kappa=1/2; Delta=n/2; post=(Delta+1):n; Nrep=1000
Alpha=0.5*(2:12)

set.seed(123)
flags=matrix(rep(0,Nrep*length(Alpha)),ncol=Nrep)
for(a in 1:length(Alpha)){
  alpha=Alpha[a]
  X=runif(n); Y=runif(n,min=-1/2,max=1/2); 
  data=all_priv_data(X,Y,h,alpha); W=data[[1]]; Z=data[[2]]
  (rejprob=changepoint_tuning(W,Z,h,C,Nperm,Nchecks))
  choice=min(which(rejprob<=gamma))
  c=C[choice]
  
  Smat=matrix(rep(1:n,Nchecks),ncol=Nchecks)
  Tmat=(n/Nchecks)*matrix(rep(1:Nchecks,n),ncol=Nchecks,byrow=TRUE)
  Scalemat=Smat*(Tmat-Smat)/Tmat
  outofbounds=(Scalemat<=0)
  Scalemat[outofbounds]=Inf; Scalemat=sqrt(Scalemat)
  b=matrix(rep(Inf,n*Nchecks),ncol=n)
  b[,1:n]=sqrt(log((n/Nchecks)*(1:Nchecks))-log(gamma*h))
  b=t(b)/(alpha*h)
  b[outofbounds]=Inf
  b=c*b
  b[b>=Scalemat]=Inf
  
  # Now that we have the thresholds we run simulations to look at the power
  
  for(nrep in 1:Nrep){
    X=runif(n); Y=runif(n,min=-1/2,max=1/2); Y[post]=Y[post]+kappa*pmin(pmax(5-10*X[post],-1),1)
    flags[a,nrep]=changepoint(X,Y,h,alpha,b,Nchecks)[[2]]
    print(nrep)
  }
  #mean(abs(flag-Delta))
  #sum(flag<Inf); sum(flag<Delta)
  print(a)
}




