import os
import sys
import json
import requests
import time

from pathlib import Path


def main(json_path):
    with open(json_path, 'r') as file:
        data = json.load(file)
    
    os.makedirs('./data', exist_ok=True)

    for movie in data['movies']:
        for movie_file, countries in movie.items():
            base_filename = movie_file.split(".")[0]
            
            for country, details in countries.items():
                out_path = './data/' + 'US-' + country
                os.makedirs(out_path, exist_ok=True)
                country_code_download_dir = Path(out_path + '/' + country + '-poster')
                country_code_download_dir.mkdir(exist_ok=True)
                image_url = details['link']
                response = requests.get(image_url)
                
                if response.status_code == 200:
                    download_dir = country_code_download_dir
                    file_path = f"{download_dir}/{movie_file}"

                    with open(file_path, 'wb') as file:
                        file.write(response.content)
                    print(f"Downloaded {file_path}")

                else:
                    print(f"Failed to download from {image_url}")
    
if __name__ == "__main__":
    main(sys.argv[1])
