from PIL import Image
import sys
import os
import json

def crop_image(image_path, top_left, bottom_right):
    image = Image.open(image_path)
    image = image.convert('RGBA')
    cropped_image = image.crop((*top_left, *bottom_right))
    return cropped_image

def main(json_path, data_dir):
    target_dir = './must-bench'
    os.makedirs(target_dir, exist_ok=True)
    with open(json_path, 'r') as file:
        data = json.load(file)
        
    for movie in data['movies']:
        for movie_file, countries in movie.items(): 
            for country, details in countries.items():
                coords = details['coords']
                available = details['available']
                if available and coords:
                    base_dir = f"{data_dir}/US-{country}"
                    save_base_dir = f"{target_dir}/{country}"
                    src_dir = os.path.join(base_dir, f"{country}-poster")
                    img_path = os.path.join(src_dir, movie_file)
                    
                    for i in range(0, len(coords), 4):
                        if i == len(coords) - 4:
                            break
                        if i+3 >= len(coords):
                            print(f"{movie_file} + {country} Invalid coordinates.")
                            break
                        top_left = (coords[i], coords[i+1])
                        bottom_right = (coords[i+2], coords[i+3])
                        cropped_image = crop_image(img_path, top_left, bottom_right)
                        base_name = movie_file.split(".")[0]

                        save_dir = os.path.join(save_base_dir, base_name)
                        os.makedirs(save_dir, exist_ok=True)
                        
                        save_path = os.path.join(save_dir, f"{i//4}.png")
                        resized_image = cropped_image.resize((256, 256))
                        resized_image.save(save_path)           

if __name__ == "__main__":
    main(sys.argv[1], sys.argv[2])
