import os
import sys
import shutil

def get_subdirectories(dir_path):
    return [d for d in os.listdir(dir_path) if os.path.isdir(os.path.join(dir_path, d))]

def main(dir1, dir2):
    base_dir = "./must-bench"
    dir1_path = os.path.join(base_dir, dir1)
    dir2_path = os.path.join(base_dir, dir2)
    
    subdirs1 = set(get_subdirectories(dir1_path))
    subdirs2 = set(get_subdirectories(dir2_path))
    common_subdirs = subdirs1.intersection(subdirs2)
    
    new_dir = base_dir + '/' + dir1 + '-' + dir2
    if not os.path.exists(new_dir):
        os.makedirs(new_dir)
    
    for subdir in common_subdirs:
        dir1_sub_path = os.path.join(dir1_path, subdir)
        dir2_sub_path = os.path.join(dir2_path, subdir)
        dst_path = os.path.join(new_dir, subdir)
        os.makedirs(dst_path, exist_ok=True)
        
        total_files = os.listdir(dir1_sub_path) + os.listdir(dir2_sub_path)
        
        for file in total_files:
            file1 = os.path.join(dir1_sub_path, file)
            file2 = os.path.join(dir2_sub_path, file)
            
            if os.path.exists(file1):
                
                shutil.copy(file1, os.path.join(dst_path, f"{dir1}_{file}"))
            if os.path.exists(file2):
                shutil.copy(file2, os.path.join(dst_path, f"{dir2}_{file}"))

if __name__ == "__main__":
    main(sys.argv[1], sys.argv[2])
