import argparse
from scripts.probe_model import main as register_probe
from scripts.probe_residuals import main as residual_probe

from scripts.make_plots import main as register_plots
from scripts.make_residual_plots import main as residual_plots

from scripts.layerwise_features import main as layerwise

def parse_args():
    parser = argparse.ArgumentParser()

    parser.add_argument(
        '--image_dir',
        help='Path to the directory containing test images',
        required=True
    )

    parser.add_argument(
        '--batch_size',
        default=16
    )

    return parser.parse_args()

def main(args):
    print('Computing results for models with registers...')
    register_probe(args)
    print('Plotting results for models with registers...')
    register_plots()

    print('Computing results for models without registers...')
    residual_probe(args)
    print('Plotting results for models without registers...')
    residual_plots()

    print('Computing layerwise similarity for models without registers...')
    layerwise(args)

if __name__ == '__main__':
    args = parse_args()
    main(args)