# coding=utf-8
# Copyright 2020 The Gsa Net Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Tests for attention layers."""
from absl.testing import parameterized
import tensorflow.compat.v1 as tf

from gsa_net.layers import attention_layers


class AttentionLayersTest(parameterized.TestCase, tf.test.TestCase):

  @parameterized.named_parameters(
      ('default', 1, True),
      ('strided', 2, True),
      ('evaluation', 1, False),
  )
  def test_attention_layer(self, strides, is_training):
    batch_size = 2
    height = 4
    width = 6
    head_count = 8
    input_depth = 16
    output_depth = 24

    inputs = tf.random_normal((batch_size, height, width, input_depth))
    outputs = attention_layers.attention_layer(
        inputs,
        output_depth,
        head_count,
        pooling_kernel_size=3,
        strides=strides,
        is_training=is_training,
        batch_norm_momentum=0.99,
        batch_norm_epsilon=1e-5,
    )
    self.assertEqual(outputs.shape, (
        batch_size, height // strides, width // strides, output_depth))

    with tf.Session() as sess:
      sess.run(tf.global_variables_initializer())
      outputs = sess.run(outputs)
    self.assertNotAllEqual(outputs, 0)


if __name__ == '__main__':
  tf.test.main()
