#!/bin/bash

#SBATCH --job-name=i_mistral_full
#SBATCH --output=i_mistral_full.out
#SBATCH --error=i_mistral_full.err
# SBATCH --job-name=i_mistral_full_scrp
# SBATCH --output=i_mistral_full_scrp.out
# SBATCH --error=i_mistral_full_scrp.err

#SBATCH --partition=compute
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=1
#SBATCH --gres=gpu:A100:2
#SBATCH --time=23:00:00
#SBATCH --mail-type=ALL
#SBATCH --mail-user=bo@andrew.cmu.edu


source ~/.bashrc
conda activate agent


accelerate launch  --main_process_port 29515 --num_processes 2 --num_machines 1 --mixed_precision "no" /data/b_ou/agent-model/LLaMA-Factory/src/train_bash.py \
    --stage sft \
    --model_name_or_path /data/b_ou/ckpts/mistral_flsh_attn/models--mistralai--Mistral-7B-Instruct-v0.1/snapshots/7ad5799710574ba1c1d953eba3077af582f3a773/ \
    --do_predict \
    --dataset m2w_text_test \
    --dataset_dir /data/b_ou/agent/data/text/ \
    --template mistral \
    --finetuning_type full \
    --checkpoint_dir /data/b_ou/ckpts/output_16k_mistral_full/checkpoint-855/ \
    --output_dir /data/b_ou/ckpts/output_16k_mistral_full/pred \
    --per_device_eval_batch_size 1 \
    --predict_with_generate True\
    --use_safetensors True \
    --cutoff_len 4096 \
    --bf16 True


# accelerate launch  --main_process_port 29516 --num_processes 2 --num_machines 1 --mixed_precision "no" /data/b_ou/LLaMA-Factory/src/train_bash.py \
#     --stage sft \
#     --model_name_or_path /data/b_ou/ckpts/mistral_flsh_attn/models--mistralai--Mistral-7B-Instruct-v0.1/snapshots/7ad5799710574ba1c1d953eba3077af582f3a773/ \
#     --do_predict \
#     --dataset m2w_text_scrape \
#     --dataset_dir /data/b_ou/agent/data/text_scrp/ \
#     --template mistral \
#     --finetuning_type full \
#     --checkpoint_dir /data/b_ou/ckpts/output_8k_mistral_full_scrp/checkpoint-780/ \
#     --output_dir /data/b_ou/ckpts/output_8k_mistral_full_scrp/pred \
#     --per_device_eval_batch_size 16 \
#     --predict_with_generate \
#     --use_safetensors True \
#     --bf16 True
