#!/usr/bin/env bash

kl_weight=1e-4
recon_weight=1e-2
hid_dims=768_384
lat_dim=64
beta_a_query=100
beta_a_entity=20
beta_b=1
dropout=0
temp=0.02
epoch=60
lr=8e-5

TOKENIZERS_PARALLELISM=true python main.py \
    --dataset WN18RR \
    --pretrained_model bert-base-uncased \
    --use_neighbor_names \
    --max_num_tokens 120 \
    --additive_margin 0.02 \
    --epochs ${epoch} \
    --eval_step 1000 \
    --batch_size 1024 \
    --lr ${lr} \
    --t ${temp} \
    --kl_weight ${kl_weight} \
    --recon_weight ${recon_weight} \
    --workers 4 \
    --scheduler cosine \
    --beta_a_query ${beta_a_query} \
    --beta_a_entity ${beta_a_entity} \
    --beta_b ${beta_b} \
    --hidden_dims ${hid_dims} \
    --latent_dim ${lat_dim} \
    --dropout ${dropout} \
    --neighbor_weight 0 \
    --rerank_n_hop 5 \
    --do_test \
    --eval_batch_size 1024 \
    --experiment_name wn18rr
