from PIL import Image
import glob
import os
import pdb

from testsets.utils import utils_blindsr as blindsr
import torchvision.transforms as transforms
import torch

if __name__ == "__main__":
    toTensor=transforms.ToTensor()
    toPIL=transforms.ToPILImage()
    root_HR=os.path.expanduser('/mnt/server5_hard1/seungjun/KAIR-master/trainsets/trainH/')
    root_X4 ='/mnt/server5_hard1/seungjun/KAIR-master/trainsets/trainL_realdegrade/X4/'


    
    for filename in glob.glob(root_HR + '*.png'):  # assuming gif
        img_=Image.open(filename).convert('RGB')

        img_name=filename.split('/')
        img_name=img_name[-1]
        img_name=img_name[:-4]+'x4.png'
        
        save_dir = root_X4+img_name
        img_tensor=toTensor(img_)
        img_tensor=img_tensor.permute(1,2,0)
        
        try:
            
            
            img_lq, img_hq = blindsr.degradation_bsrgan(img_tensor.numpy(), sf=4, lq_patchsize=72)
            img_lq=torch.from_numpy(img_lq)
            img_lq=img_lq.permute(2,0,1)
            img_lq=toPIL(img_lq)
            img_lq =img_lq.resize((img_lq.width*4,img_lq.height*4),Image.BICUBIC)
        except:
            img_=img_.resize((img_.width//4, img_.height//4))
            img_lq =img_.resize((img_.width*4,img_.height*4),Image.BICUBIC)
        
        
        img_lq.save(save_dir)
        print("saving {}".format(save_dir),flush=True)