#!/bin/bash
#SBATCH -p part1
#SBATCH -N 1
#SBATCH -n 1
#SBATCH -o stdout.%j
#SBATCH -e stderr.%j
#SBATCH --gres=gpu:1

conda activate sj_sr


python -m torch.distributed.launch --nproc_per_node=4 --master_port=1234 main_train_psnr.py --opt options/swinir/train_swinir_sr_realworld_x4_psnr.json  --dist True > Logging_swinir_realworld_x4_psnr.txt

#python -m torch.distributed.launch --nproc_per_node=4 --master_port=1234 main_train_psnr2.py --opt options/swinir/train_swinir_sr_realworld_x4_psnr.json  --dist True

# CUDA_VISIBLE_DEVICES=3 python tools/train.py configs/xSatelite/faster_rcnn_RoITrans_r50_fpn_1x_xSate.py

python -m torch.distributed.launch --nproc_per_node=4 --master_port=1234 main_train_psnr.py --opt options/swinir/train_swinir_sr_realworld_x4_gan.json --dist True > Logging_swinir_realworld_x4_gan.txt

python -m torch.distributed.launch --nproc_per_node=4 --master_port=1234 main_train_psnr_Deepten.py --opt options/swinir/train_swinir_sr_realworld_x4_gan.json --dist True > Logging_swinir_realworld_x4_gan_Deepten5.txt


## use BSRGAN's synthesis method to make real degradation LR images
python -m torch.distributed.launch --nproc_per_node=4 --master_port=1234 main_train_psnr_Deepten.py --opt options/swinir/train_swinir_sr_realDegrade_x4_gan.json --dist True > Logging_swinir_realDegrade_x4_gan_Deepten3.txt

## use BSRGAN's synthesis method to make real degradation LR images
python -m torch.distributed.launch --nproc_per_node=4 --master_port=1234 main_train_psnr_Deepten.py --opt options/train_bsrgan_realDegrade_x4_gan.json --dist True > Logging_bsrgan_realDegrade_x4_gan_Deepten3.txt


## train Naive BSRGAN on DIV2K+FLICKR2K+OST ONLY
python -m torch.distributed.launch --nproc_per_node=4 --master_port=1234 main_train_psnr_Deepten.py --opt options/train_bsrgan_realDegrade_x4_lsgan_original.json --noDT True --dist True > Logging_bsrgan_original_realDegrade_x4_Deepten3.txt


## train Naive SRFormer on DIV2K+FLICKR2K+OST ONLY (train from server9 = 5,6,7,8 GPUS)
python -m torch.distributed.launch --nproc_per_node=4 --master_port=5678 main_train_psnr_Deepten.py --opt options/train_SRFormer_realDegrade_x4_gan_original.json --noDT True --dist True > Logging_srformer_original_realDegrade_x4.txt

## train SRFormer+SAITGAN on DIV2K+FLICKR2K+OST ONLY
python -m torch.distributed.launch --nproc_per_node=4 --master_port=1234 main_train_psnr_Deepten.py --opt options/train_SRFormer_realDegrade_x4_gan.json --dist True > Logging_srformer_realDegrade_x4_Deepten3.txt


python -m torch.distributed.launch --nproc_per_node=4 --master_port=1234 main_train_psnr_Deepten.py --opt options/train_bsrgan_realDegrade_x4_lsgan.json --dist True > Logging_bsrgan_realDegrade_x4_lsgan_Deepten3.txt






conda deactivate