#!/bin/bash
export CUDA_VISIBLE_DEVICES=

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PARENT_DIR="$(dirname "$SCRIPT_DIR")"
PARENT_DIR="$(dirname "$PARENT_DIR")"

source $SCRIPT_DIR/constants.sh

# CHANGE ME
mode= # can be 'rded', 'lpld', 'fadrm', or 'sre2l'
train_mode= # can be 'ours' or 'lpld' (Soft-Only)

Model_Name=ResNet18
hyper_loc=$PARENT_DIR/hyper.yaml

# SLC could be 50-300
slc=50
ipc=30
s=$((slc / ipc))

# 路径设置
ODP=${Generated_Data_Path}/syn_data/${Dataset_Name}/${mode}_ipc${ipc}
FKD=${Generated_Data_Path}/new_crops/${Dataset_Name}/${mode}_slc${slc}_ipc${ipc}
OPD=${Generated_Data_Path}/new_validate/

EXP_NAME="${mode}_${train_mode}_slc${slc}_ipc${ipc}_${Model_Name}"
WANDB_PROJECT="new_exp"
echo ">>> Running slc=$slc, ipc=$ipc, s=$s"

python -u $PARENT_DIR/post_eval.py \
    --config-path $hyper_loc \
    --model $Model_Name \
    --ipc $ipc \
    --SLC $slc \
    --train-mode ${train_mode} \
    --img-mode ${mode} \
    --simple \
    --wandb-project $WANDB_PROJECT \
    --exp-name $EXP_NAME \
    --train-dir $ODP \
    --crop-dir $FKD \
    --output-dir $OPD \
    --dataset-name $Dataset_Name \
    --test-dir $val_dir 