#!/bin/bash

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PARENT_DIR="$(dirname "$SCRIPT_DIR")"
PARENT_DIR="$(dirname "$PARENT_DIR")"

source $SCRIPT_DIR/constants.sh

mode= # set this to 'lpld' or 'rded' or 'fadrm' or 'sre2l'
Model_Name=ResNet18
hyper_loc=$PARENT_DIR/hyper.yaml

for slc in 300 250 200 150 100 50
do
  for ipc in 10 20 30 40 50
  do
    s=$((slc / ipc)) 

    echo ">>> Cropping slc=$slc, ipc=$ipc, s=$s"

    python $PARENT_DIR/soft_img_generation.py \
    --src_dir $Generated_Data_Path/syn_data/imagenet1k/${mode}_ipc${ipc} \
    --dst_dir $Generated_Data_Path/new_crops/imagenet1k/${mode}_slc${slc}_ipc${ipc} \
    --crop_size 224 \
    --num_crops $s \
    --num_workers 10
  done
done
