import ctypes
import numpy as np
from numpy.ctypeslib import as_ctypes
import os
import os.path as osp


def openlib():
    dirname = osp.join(*osp.split(__file__)[:-1])
    path = osp.join(dirname, "clib.so")
    os.system(f"cd {dirname}; make")
    return ctypes.CDLL(path) 

def build(order, metric):
    """
    Returns:
        index_2_bitmap, bitmap_2_index, grades, table
    """
    dim = 1 << order
    arange = np.arange(dim, dtype=np.int32)
    grades = np.empty_like(arange, dtype=np.int32)
    index_2_bitmap = np.empty_like(arange, dtype=np.int32)

    lib = openlib()
    lib.bldbasis(as_ctypes(arange),
                 as_ctypes(index_2_bitmap),
                 as_ctypes(grades),
                 dim)
    grades.sort()
    bitmap_2_index = np.empty_like(index_2_bitmap, dtype=np.int32)
    bitmap_2_index[index_2_bitmap] = arange
    table = np.zeros((dim * dim * dim, ), dtype=np.float32)
    lib.gmt(as_ctypes(index_2_bitmap),
            as_ctypes(bitmap_2_index),
            as_ctypes(metric.astype(np.float32)),
            as_ctypes(table),
            dim)

    return index_2_bitmap, bitmap_2_index, grades, table.reshape(dim, dim, dim)

