from task_0.task import Task
from constants import *
from video_recorder import video_recorder
import random
import numpy as np
import itertools
import omnigibson as og

SCENES = ["Beechwood_0_int"]
SUBTASKS = ["Cook", "Clean", "Wash", "Pour", "PickAndPlace"]

def sample_sequence_task(sub_task_num=3, sample_num=3, scenes=SCENES, subtasks=SUBTASKS):

    print("----------------------")
    print(f"Sample sequence tasks")
    print("----------------------")

    sequence_preferences = list(itertools.permutations(subtasks, sub_task_num))
    
    for sequence_preference in sequence_preferences:
        print(f"Sequence preference: {sequence_preference}")
        for scene_model in scenes:
            for i in range(sample_num):
                sub_task_nums = dict(zip(sequence_preference, np.random.randint(1, 3, sub_task_num)))
                
                task = Task(task_flag="SequencePlanning", task_name=f"{sequence_preference}", task_id=i,\
                                    scene_model=scene_model, sub_task_nums=sub_task_nums)
                task.init_figure()
                task.step()
                task.close()
                video_recorder.release()

    # Always shut the simulation down cleanly at the end
    og.app.close()

if __name__ == "__main__":
    sample_sequence_task(sub_task_num=3, sample_num=1, scenes=SceneInfo.keys(), subtasks=Subtasks.keys())