from task import Task
from constants import *
import random
import numpy as np
import omnigibson as og

SCENES = ["Beechwood_int_0"]
SUBTASKS = ["Cook", "Clean", "Wash", "Pour", "PickAndPlace"]

def sample_sequence_task(sample_num=1, scenes=SCENES, subtasks=SUBTASKS):

    print("----------------------")
    print(f"Sample sequence tasks")
    print("----------------------")
    
    sub_task_names = random.sample(subtasks, sample_num)
    print(f"Sequence preference: {sub_task_names}")

    for scene_model in scenes:
        sub_task_nums = dict(zip(sub_task_names,np.random.randint(1, 3, sample_num)))
        
        task = Task(task_flag="SequencePlanning", task_name=f"{sub_task_names}_{scene_model}",\
                            scene_model=scene_model, sub_task_nums=sub_task_nums)
        task.init_figure(save_path=f"{sub_task_names}_{scene_model}",\
                         save_name=f"{sub_task_names}_{scene_model}")
        try:
            task.step()
        except Exception as e:
            print(e)
        task.close()
        
    # Always shut the simulation down cleanly at the end
    og.app.close()

if __name__ == "__main__":
    # sample_sequence_task(sample_num=1, scenes=SceneInfo.keys(), subtasks=Subtasks.keys())
    sample_sequence_task(sample_num=1, scenes=SceneInfo.keys(), subtasks=["Pour"])