import sys
import os
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
import time
from language_control.llm import GPT
import re
import json
from prompt_en import prompt_generate_instrution_ttc_lane_en, \
    prompt_generate_instrution_speed_lane_en, prompt_generate_instrution_speed_change_en


def replace_keywords_in_string(s, keywords, replacement):
    pattern = '|'.join(map(re.escape, keywords))
    result = re.sub(pattern, replacement, s)
    return result

        
def generate_speed_lane_instructions():
    # EN
    llm = GPT()
    speed_list = ['Faster', 'Slower', '']
    lane_list = ['Left Lane', 'Middle Lane', 'Right Lane', '']
    
    instruction_result = {}
    for speed in speed_list:
        for lane in lane_list:
            instruction = f'{speed}, {lane}, Driving'
            if lane == '' and speed == '':
                continue
            human_prompt = prompt_generate_instrution_speed_lane_en.format(instruction=instruction)
            messages = [{"role": "user", "content": human_prompt.content}]
            begin_time = time.time()
            response = llm.call(messages)
            data = response['content']
            data = data.split('\n')
            instructions_dict = {}
            for line in data:
                print(line)
                if line.strip():
                    id_str, text = line.split('. ', 1)
                    instructions_dict[int(id_str)] = text
            instruction_result[instruction] = instructions_dict
            end_time = time.time() - begin_time
            print('end_time:', end_time)

    with open('instructions/speed_lane_instructions_gpt4o_en.json', 'w', encoding='utf-8') as f:
        json.dump(instruction_result, f, ensure_ascii=False, indent=4)


def generate_ttc_lane_instructions():
    # EN
    llm = GPT()
    ttc_list = ['Larger Distance', 'Closer Distance']
    lane_list = ['Left Lane', 'Middle Lane', 'Right Lane', '']

    instruction_result = {}
    for ttc in ttc_list:
        for lane in lane_list:
            instruction = f'{ttc}, {lane}, Driving'
            human_prompt = prompt_generate_instrution_ttc_lane_en.format(instruction=instruction)
            messages = [{"role": "user", "content": human_prompt.content}]
            begin_time = time.time()
            response = llm.call(messages)
            data = response['content']
            data = data.split('\n')
            instructions_dict = {}
            for line in data:
                print(line)
                if line.strip():
                    id_str, text = line.split('. ', 1)
                    instructions_dict[int(id_str)] = text
            instruction_result[instruction] = instructions_dict
            end_time = time.time() - begin_time
            print('end_time:', end_time)

    with open('instructions/ttc_lane_instructions_gpt4o_en.json', 'w', encoding='utf-8') as f:
        json.dump(instruction_result, f, ensure_ascii=False, indent=4)


def generate_speed_change_instructions():
    # EN
    llm = GPT()
    speed_list = ['Faster', 'Slower', '']
    change_list = ['Frequent', 'Minimal']

    instruction_result = {}
    for speed in speed_list:
        for change in change_list:
            instruction = f'{speed}, {change}, Driving'
            # if lane == '' and speed == '':
            #     continue
            human_prompt = prompt_generate_instrution_speed_change_en.format(instruction=instruction)
            messages = [{"role": "user", "content": human_prompt.content}]
            begin_time = time.time()
            response = llm.call(messages)
            data = response['content']
            data = data.split('\n')
            instructions_dict = {}
            for line in data:
                print(line)
                if line.strip():
                    id_str, text = line.split('. ', 1)
                    instructions_dict[int(id_str)] = text
            instruction_result[instruction] = instructions_dict
            end_time = time.time() - begin_time
            print('end_time:', end_time)

    with open('instructions/speed_change_instructions_gpt4o_en.json', 'w', encoding='utf-8') as f:
        json.dump(instruction_result, f, ensure_ascii=False, indent=4)


if __name__ == "__main__":
    generate_speed_change_instructions()
    generate_speed_lane_instructions()
    generate_ttc_lane_instructions()
