from langchain.prompts import HumanMessagePromptTemplate


prompt_generate_instrution_speed_change_en = HumanMessagePromptTemplate.from_template(
    """
    You are an assistant for a drive game, and you need to describe executable commands in the game using natural language. 
    Below are explanations and examples of the commands:
    
    Speed Control
    Speed Control include: Faster, Slower
    
    Change Lane Frequency Control
    Change Lane Frequency include: Frequent, Minimal
    
    Drive actions include: Driving
    
    Aliases
    The Frequent can also be represented by "Continually", "... as often as possible", "Maximize ... changes"
    The Minimal can also be represented by "Limit...", "Keep ... to a minimum", "Avoid changing ..."
    Driving can also be called "On the road", "Take the wheel" "Hit the road" etc.
    
    Commands
    Commands are combinations of Speed Control, Change Lane Frequency Control, and Driving, for example:
    "Drive at a higher speed and change lanes more frequently."
    "Decrease your speed and increase the frequency of lane changes."
    "Maintain your current speed and decrease the frequency of lane changes."
    "Switch lanes as often as possible."
    
    Example 1
    Command: "Faster, Frequent, Driving" 
    Natural language: 
    "Accelerate and switch lanes continually while driving."
    "Increase your speed and change lanes as often as possible while on the road."
    "Drive faster and maximize lane changes."
    
    Example 2
    Command: "Slower, Minimal, Driving"
    Natural language: 
    "Decrease your speed and avoid frequent lane changes while driving."
    "Slow down and keep lane changes to a minimum while on the road."
    "Reduce your speed and limit lane changes while taking the wheel."
    
    Example 3
    Command: ", Frequent, Driving"
    Natural language: 
    "Change lanes as often as possible while driving."
    "Maximize lane changes while on the road."
    "Continually switch lanes while hitting the road."
    
    For each command, generate ten diverse natural language descriptions, separated by line breaks, starting with a numerical ID.
    For example:
    1. xxxxx
    2. xxxxx 
    ...
    10. xxxxx
    
    Note: The generated sentences must have different lengths, different punctuation, and different word orders.
    Use the aliases for Slower, Left Lane, and Driving.
    For example:
    1. Switch lanes as often as possible.
    2. Continue at the same speed and maintain your lane changing rate while on the road.
    
    Command:
    {instruction}
    Natural language:
    """
)

prompt_generate_instrution_speed_lane_en = HumanMessagePromptTemplate.from_template(
    """
    You are an assistant for a drive game, and you need to describe executable commands in the game using natural language. 
    Below are explanations and examples of the commands:
    
    Speed Control
    Speed Control include: Faster, Slower
    
    Drive Lane
    Drive Lanes include: Left Lane, Middle Lane, Right Lane
    
    Drive actions include: Driving
    
    Aliases
    The Left Lane can also be called the "Fast Lane" 
    The Right Lane can also be called the "Slow Lane" 
    The Middle Lane can also be called the "Center Lane" 
    Driving can also be called "On the road", "Take the wheel" "Hit the road" etc.
    
    Commands
    Commands are combinations of Speed Control, Drive Lane, and Driving, for example:
    Accelerate in the left lane
    Maintain current speed in the middle lane
    Drive in the right lane
    Driving faster
    
    Example 1
    Command: "Faster, Left Lane, Driving" 
    Natural language: 
    "Accelerate and drive in the left lane."
    "Speed up and take the fast lane."
    "Push the pedal to the metal and steer your way into the fast lane."
    
    Example 2
    Command: ", Middle Lane, Driving"
    Natural language: 
    "Stay in the middle lane."
    "Drive in the center lane."
    "Hold your pace steady and keep your vehicle cruising in the center lane."
    
    Example 3
    Command: "Slower, Right Lane, Driving"
    Natural language: 
    "Slow down and move to the right lane."
    "Reduce your speed and move to the slow lane."
    "More safer driving to the slow lane."
    
    Example 4
    Command: "Faster, Driving"
    Natural language: 
    "Drive faster."
    "Accelerate!"
    "Sprint!"
    
    For each command, generate ten diverse natural language descriptions, separated by line breaks, starting with a numerical ID.
    For example:
    1. xxxxx
    2. xxxxx 
    ...
    10. xxxxx
    
    Note: The generated sentences must have different lengths, different punctuation, and different word orders.
    Use the aliases for Slower, Left Lane, and Driving.
    For example:
    1. Slow down and move to the left lane.
    2. Cruise like a turtle in the fast lane.
    
    Command:
    {instruction}
    Natural language:
    """
)

prompt_generate_instrution_ttc_lane_en = HumanMessagePromptTemplate.from_template(
    """
    You are an assistant for a drive game, and you need to describe executable commands in the game using natural language. 
    Below are explanations and examples of the commands:
    
    Vehicle Distance Control
    Vehicle Distance Control include: Larger Distance, Closer Distance
    
    Drive Lane
    Drive Lanes include: Left Lane, Middle Lane, Right Lane
    
    Drive actions include: Driving
    
    Aliases
    The Larger Distance can also be represented by "wider space", "bigger buffer zone", "more substantial distance"
    The Closer Distance can also be represented by "More closer" "shorter distance", "more proximate distance"
    The Left Lane can also be called the "Fast Lane" 
    The Right Lane can also be called the "Slow Lane" 
    The Middle Lane can also be called the "Center Lane" 
    Driving can also be called "On the road", "Take the wheel" "Hit the road" etc.
    
    Commands
    Commands are combinations of Vehicle Distance Control, Drive Lane, and Driving, for example:
    "Maintain a larger distance between cars while driving in the left lane."
    "Keep a smaller gap between vehicles while driving in the right lane."
    "Drive normally while in the middle lane."
    
    Example 1
    Command: "Larger Distance, Left Lane, Driving" 
    Natural language: 
    "Maintain a wider space between cars while driving in the fast lane."
    "Preserve a bigger buffer zone with the vehicle ahead while in the left lane."
    "Hold a more substantial distance from the car in front while driving on the left."
    
    Example 2
    Command: "Closer Distance, Middle Lane, Driving"
    Natural language: 
    "Maintain a shorter distance with the car ahead while driving in the center lane."
    "Keep a more proximate distance from the vehicle in front while in the middle lane."
    "Reduce the gap between you and the car ahead while driving in the middle lane."
    
    Example 3
    Command: "Larger Distance, Driving"
    Natural language: 
    "Ensure a wider space between you and the car in front while driving."
    "Maintain a larger distance between cars while on the road."
    "Preserve a bigger buffer zone with the vehicle ahead while taking the wheel."
    
    For each command, generate ten diverse natural language descriptions, separated by line breaks, starting with a numerical ID.
    For example:
    1. xxxxx
    2. xxxxx 
    ...
    10. xxxxx
    
    Note: The generated sentences must have different lengths, different punctuation, and different word orders.
    Use the aliases for Larger Distance, Left Lane, and Driving.
    For example:
    1. Keep larger distance on the left lane.
    2. I think we can have a wider space between you and the car in front while driving on the fast lane.
    
    Command:
    {instruction}
    Natural language:
    """
)
