import json
import zmq
import pickle
import os
from learner.utils import recursive_update


class BasicServer:
    def __init__(self):
        with open('config.json')as f:
            json_str = f.read()
        self.json_config = json.loads(json_str)

        self.log_dir = self.json_config["log_dir"]

        self.context = zmq.Context()
        self.context.setsockopt(zmq.MAX_SOCKETS, 102400)
        self.poller = zmq.Poller()

        # send to log server
        self.log_sender = self.context.socket(zmq.PUSH)
        self.log_sender.connect("tcp://%s:%d" % (self.json_config["log_server_address"],
                                                 self.json_config["log_server_port"]))
        # cached log
        self.cached_log_list = []

    def send_log(self, log_dict, send_threshold=3):
        self.cached_log_list.append(log_dict)
        if len(self.cached_log_list) > send_threshold:
            p = pickle.dumps(self.cached_log_list)
            self.log_sender.send(p)
            self.cached_log_list = []

    def _hot_update(self, update_dict):
        recursive_update(self.json_config, update_dict)
