## Instructions for reproducing experiments
GCM is currently publically available on github and as a python package via pip. If you have the latest version of pytorch and pytorch-geometric installed, you can install it using:

`pip install graph-conv-memory`

Alternatively, install deps via conda then GCM
```bash
conda install torch
conda install pytorch-geometric -c rusty1s -c conda-forge
pip install graph-conv-memory
```
PLEASE INSTALL PYTORCH GEOMETRIC V1.7.0. Newer versions of pytorch geometric do not pickle correctly and will fail when trained with with ray rllib. If you are not using Ray rllib, then the latest version should work.

Please do not visit the actual pip package page or github repo, as these contain information that will violate the double-blind reviewing setup. You may browse the repo anonymously at https://anonymous.4open.science/r/graph-conv-memory-55AD/README.md for more information on how to use GCM.

The code is documented, so feel free to try out GCM on your own tasks, or read and ask questions based on the code. The repository code is subject to change (e.g. new features, better hyperparmeters) between the ICLR submission deadline and now, when you are reading this. For this reason, we are also including the repo, located in the gcm directory. We also host a dockerfile containing the code used for experiments. You must have nvidia-docker plugin installed for GPU usage within docker. PLEASE DO NOT OPEN THE DOCKERFILE AS IT CONTAINS IDENTIFYING INFORMATION. Instead, pull and run the dockerfile following
```bash
# Setup docker to rerun our experiments
cd path_to_directory_containing_this_readme
docker image build . --tag iclr_docker:latest &> /dev/null # redir output so you don’t see the repo name and violate confidentiality agreement
# Get some coffee, the image is 20ish GB and will take a while to pull
# Ensure build was successful, the following should output '0'
echo $?
docker run --gpus all --shm-size <At least a few GB> -p 8299:8265 -p 6099:6006 -ti iclr_docker:latest

# Now you should be in the container
# You can rerun experiments following:
cd /root/vnav/src
python3 start.py cfg/cartpole.py --object-store-mem <roughly the shm-size in bytes>
python3 start.py cfg/memory.py # concentration card game --object-store-mem <roughly the shm-size in bytes>
python3 start.py cfg/navigation.py --object-store-mem <roughly the shm-size in bytes>
# Tensorboard results will be logged to /root/ray_results for your inspection
```

We train using a GPU. If you do not have a GPU, you should change the lines in the cfg files (e.g. cfg/cartpole.py) to:
```
"num_gpus": 0
"num_gpus_per_worker": 0
```
Ray requires multiple CPU cores to run a job. Ensure you have more than one available if using a VM. All our experiments were run in a Docker container running Ubuntu 20.04 on a Ubuntu host running 18.04.

We are legally prohibited from sharing the scenes used in the navigation experiment. To reproduce this experiment, you will need to get permission for the MP3D dataset (see https://github.com/facebookresearch/habitat-lab#data), then bindmount the dataset into docker at /root/scene_datasets/mp3d
